/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.l2j.gameserver.TransactionManager;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.Transactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private int transactionID;
    private Date completed;
    private Transactor transactor;
    private TransactorState transactorState;
    private Transactor transactee;
    private TransactorState transacteeState;
    private ArrayList<Transactor> participants;

    public Transaction(Transactor transactor, Transactor transactee) {
        this.transactor = transactor;
        this.transactorState = TransactorState.ACCEPTED;
        this.transactee = transactee;
        this.transacteeState = TransactorState.DECIDING;
        transactee.setTradeRequestor(transactor);
        transactor.setTradeRequestor(transactee);
        this.participants = new ArrayList();
        this.participants.add(transactor);
        this.participants.add(transactee);
        this.transactionID = TransactionManager.getNewTransactionID();
        transactee.addNewTransaction(transactor, this.transactionID);
        transactor.addNewTransaction(transactee, this.transactionID);
    }

    public List<Transactor> getParticipants() {
        return this.participants;
    }

    public int getTransactionID() {
        return this.transactionID;
    }

    public TransactorState getState(Transactor transactor) {
        if (this.transactor == transactor) {
            return this.transactorState;
        }
        if (this.transactee == transactor) {
            return this.transacteeState;
        }
        return null;
    }

    public Date getCompletedDate() {
        return this.completed;
    }

    public void setDateCompleted(Date date) {
        this.completed = date;
    }

    public boolean equals(Object object) {
        return object instanceof Transaction && ((Transaction)object).transactionID == this.transactionID;
    }

    public void acceptedRequest(Transactor transactee) {
        this.transacteeState = TransactorState.ACCEPTED;
    }

    public void cancel() {
        this.transactee.cancelTransaction(this.transactor);
        this.transactor.cancelTransaction(this.transactee);
    }

    public void addItemListToTrade(Transactor transactor, List<L2ItemInstance> itemList) {
        if (this.transactor == transactor) {
            this.transactor.addItemList(itemList);
            if (this.transacteeState == TransactorState.CONFIRMED) {
                this.transacteeState = TransactorState.ACCEPTED;
            }
        } else if (this.transactee == transactor) {
            this.transactee.addItemList(itemList);
            if (this.transactorState == TransactorState.CONFIRMED) {
                this.transactorState = TransactorState.ACCEPTED;
            }
        }
    }

    public void confirmTrade(Transactor transactor) {
        if (this.transactor == transactor) {
            this.transactorState = TransactorState.CONFIRMED;
        } else if (this.transactee == transactor) {
            this.transacteeState = TransactorState.CONFIRMED;
        }
    }

    public boolean transactionConfirmed() {
        return !(this.transactorState != TransactorState.CONFIRMED && this.transactorState != TransactorState.SWAPPING && this.transactorState != TransactorState.RETREIVED || this.transacteeState != TransactorState.SWAPPING && this.transacteeState != TransactorState.CONFIRMED && this.transacteeState != TransactorState.RETREIVED);
    }

    public List<L2ItemInstance> getTradeList(Transactor transactor) {
        if (this.transactor == transactor) {
            if (this.transactorState == TransactorState.CONFIRMED) {
                this.transactorState = TransactorState.SWAPPING;
                return transactor.getTradeList();
            }
            if (this.transactorState == TransactorState.SWAPPING) {
                this.transactorState = TransactorState.RETREIVED;
                return transactor.getTradeList();
            }
        } else if (this.transactee == transactor) {
            if (this.transacteeState == TransactorState.CONFIRMED) {
                this.transacteeState = TransactorState.SWAPPING;
                return this.transactee.getTradeList();
            }
            if (this.transacteeState == TransactorState.SWAPPING) {
                this.transacteeState = TransactorState.RETREIVED;
                return this.transactee.getTradeList();
            }
        }
        return null;
    }

    public boolean isTransactionFinished() {
        return this.transactorState == TransactorState.RETREIVED && this.transacteeState == TransactorState.RETREIVED;
    }

    public Transactor getTransactee() {
        return this.transactee;
    }

    public Transactor getTransactor() {
        return this.transactor;
    }

    public TransactorState getTransacteeState() {
        return this.transacteeState;
    }

    public TransactorState getTransactorState() {
        return this.transactorState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransactorState {
        ACCEPTED,
        DECIDING,
        CONFIRMED,
        SWAPPING,
        RETREIVED;

    }
}

