/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transactor {
    private int id;
    private String name;
    private Object object;
    private List<L2ItemInstance> tradeList;
    private Transactor tradeRequestor;
    private Hashtable<Transactor, Integer> currentTransactions;

    public Transactor(Object transactor, int transactorID, String newName) {
        this.id = transactorID;
        this.name = newName;
        this.object = transactor;
        this.tradeList = new ArrayList<L2ItemInstance>();
        this.currentTransactions = new Hashtable();
    }

    public Set<Transactor> getTransactingPartners() {
        return this.currentTransactions.keySet();
    }

    public Collection<Integer> getTransactionIds() {
        return this.currentTransactions.values();
    }

    public Object getObject() {
        return this.object;
    }

    public Transactor(Object transactor) {
        this(transactor, Transactor.getTransactorID(transactor), Transactor.getTransactorName(transactor));
    }

    public Transactor getTradeRequestor() {
        return this.tradeRequestor;
    }

    public void clearTradeRequestor() {
        this.tradeRequestor = null;
    }

    public void setTradeRequestor(Transactor requestor) {
        this.tradeRequestor = requestor;
    }

    public static int getTransactorID(Object object) {
        if (object instanceof L2Object) {
            return ((L2Object)object).getObjectId();
        }
        return -1;
    }

    public static String getTransactorName(Object object) {
        if (object instanceof L2Character) {
            return "" + ((L2Character)object).getName();
        }
        return "NoName";
    }

    public List<L2ItemInstance> getTradeList() {
        return this.tradeList;
    }

    public void setTradeList(List<L2ItemInstance> tradeList) {
        this.tradeList = tradeList;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(L2ItemInstance newItem) {
        List<L2ItemInstance> list = this.tradeList;
        synchronized (list) {
            if (newItem.isStackable()) {
                for (L2ItemInstance item : this.tradeList) {
                    if (item.getItemId() != newItem.getItemId()) continue;
                    int newAmount = item.getCount() + newItem.getCount();
                    item.setCount(newAmount);
                    newItem.setCount(0);
                    return;
                }
            }
            this.tradeList.add(newItem);
        }
    }

    public L2ItemInstance removeItem(int itemObjectID) {
        return this.removeItem(itemObjectID, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance removeItem(int itemObjectID, int amountToRemove) {
        List<L2ItemInstance> list = this.tradeList;
        synchronized (list) {
            for (L2ItemInstance item : this.tradeList) {
                if (item.getObjectId() != itemObjectID) continue;
                int amountOfItem = item.getCount();
                if (amountToRemove > 0 && item.isStackable()) {
                    if (amountOfItem > amountToRemove) {
                        item.setCount(amountOfItem - amountToRemove);
                        L2ItemInstance newItem = ItemTable.getInstance().createItem(item.getItemId());
                        newItem.setCount(amountToRemove);
                        return newItem;
                    }
                    if (amountOfItem != amountToRemove) continue;
                    this.tradeList.remove(item);
                    return item;
                }
                this.tradeList.remove(item);
                return item;
            }
        }
        return null;
    }

    public void addNewTransaction(Transactor transactee, int transactionID) {
        this.currentTransactions.put(transactee, transactionID);
    }

    public int getTransactionID(Transactor transactee) {
        if (this.currentTransactions.get(transactee) == null) {
            return -1;
        }
        return this.currentTransactions.get(transactee);
    }

    public void cancelTransaction(Transactor transactor) {
        this.currentTransactions.remove(transactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemList(List<L2ItemInstance> itemList) {
        List<L2ItemInstance> list = this.tradeList;
        synchronized (list) {
            ArrayList<L2ItemInstance> tempList = new ArrayList<L2ItemInstance>();
            for (L2ItemInstance newItem : itemList) {
                if (newItem.isStackable()) {
                    for (L2ItemInstance item : this.tradeList) {
                        if (item.getItemId() != newItem.getItemId()) continue;
                        int newAmount = item.getCount() + newItem.getCount();
                        item.setCount(newAmount);
                        tempList.add(newItem);
                    }
                }
                this.tradeList.add(newItem);
            }
            this.tradeList.removeAll(tempList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<L2ItemInstance> removeItemList(Hashtable<Integer, Integer> itemList) {
        Set<Integer> itemObjectIdList;
        ArrayList<L2ItemInstance> removedItems = new ArrayList<L2ItemInstance>();
        Set<Integer> set2 = itemObjectIdList = itemList.keySet();
        synchronized (set2) {
            for (int itemObjectId : itemObjectIdList) {
                L2ItemInstance removedItem = this.removeItem(itemObjectId, itemList.get(itemObjectId));
                if (removedItem == null) {
                    return null;
                }
                removedItems.add(removedItem);
            }
        }
        if (removedItems.size() <= 0) {
            return null;
        }
        return removedItems;
    }

    public int getTransactionsInProgress() {
        return this.currentTransactions.size();
    }
}

