/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2World;

public abstract class Warehouse {
    private static final Logger _log = Logger.getLogger(Warehouse.class.getName());

    public abstract int getOwnerId();

    public abstract L2ItemInstance.ItemLocation getLocationType();

    public abstract int getLocationId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized L2ItemInstance[] listItems() {
        ArrayList<L2ItemInstance> items = new ArrayList<L2ItemInstance>();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id FROM items WHERE owner_id=? AND loc=? AND loc_data=? ORDER BY object_id DESC");
            statement.setInt(1, this.getOwnerId());
            statement.setString(2, this.getLocationType().name());
            statement.setInt(3, this.getLocationId());
            ResultSet inv = statement.executeQuery();
            while (inv.next()) {
                int objectId = inv.getInt(1);
                L2ItemInstance item = L2ItemInstance.restoreFromDb(objectId);
                if (item == null) continue;
                items.add(item);
            }
            inv.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "could not restore warehouse:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        return items.toArray(new L2ItemInstance[items.size()]);
    }

    public synchronized L2ItemInstance addItem(L2ItemInstance newItem) {
        L2ItemInstance oldItem = null;
        if (!newItem.isStackable() || (oldItem = this.findItemId(newItem.getItemId())) == null) {
            newItem.setOwnerId(this.getOwnerId());
            newItem.setLocation(this.getLocationType(), this.getLocationId());
            newItem.setLastChange(1);
            newItem.updateDatabase();
            return newItem;
        }
        oldItem.setCount(oldItem.getCount() + newItem.getCount());
        oldItem.setLastChange(2);
        newItem.setCount(0);
        newItem.setOwnerId(0);
        newItem.setLocation(L2ItemInstance.ItemLocation.VOID);
        oldItem.updateDatabase();
        newItem.updateDatabase();
        L2World.getInstance().removeObject(newItem);
        return oldItem;
    }

    public L2ItemInstance destroyItem(int itemId, int count) {
        L2ItemInstance item = this.findItemId(itemId);
        if (item != null) {
            if (item.getCount() <= count) {
                item.setCount(0);
                item.setLocation(L2ItemInstance.ItemLocation.VOID);
                item.setLastChange(3);
                item.updateDatabase();
            } else {
                item.setCount(item.getCount() - count);
                item.setLastChange(2);
                item.updateDatabase();
            }
        } else if (Config.DEBUG) {
            _log.fine("can't destroy " + count + " item(s) " + itemId);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance findItemId(int itemId) {
        L2ItemInstance foundItem = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id FROM items WHERE owner_id=? AND loc=? AND loc_data=? AND item_id=? ");
            statement.setInt(1, this.getOwnerId());
            statement.setString(2, this.getLocationType().name());
            statement.setInt(3, this.getLocationId());
            statement.setInt(4, itemId);
            ResultSet inv = statement.executeQuery();
            if (inv.next()) {
                int objectId = inv.getInt(1);
                foundItem = L2ItemInstance.restoreFromDb(objectId);
            }
            inv.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not list warehouse:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return foundItem;
    }
}

