/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model.quest;

import java.util.ArrayList;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.quest.QuestState;
import net.sf.l2j.gameserver.model.quest.State;

public class QuestDropInfo {
    public ArrayList<DropInfo> dropList;

    public QuestDropInfo(L2PcInstance pcInstance, String questName) {
        QuestState questState = pcInstance.getQuestState(questName);
        State currentState = questState.getState();
        this.dropList = new ArrayList();
        for (int npcId : currentState.getKillIds()) {
            ArrayList<L2DropData> questDrop = questState.getDrops().get(npcId);
            if (questDrop == null) continue;
            for (L2DropData dropInfo : questDrop) {
                int dropID = dropInfo.getItemId();
                int dropObjID = 0;
                int dropCount = questState.getQuestItemsCount(dropID);
                if (pcInstance.getInventory().getItemByItemId(dropID) == null) continue;
                dropObjID = pcInstance.getInventory().getItemByItemId(dropID).getObjectId();
                this.dropList.add(new DropInfo(dropID, dropCount, dropObjID));
            }
        }
    }

    public class DropInfo {
        public int dropItemID;
        public int dropItemObjID;
        public int dropItemCount;

        public DropInfo(int itemID, int itemCount, int itemObjID) {
            this.dropItemID = itemID;
            this.dropItemObjID = itemObjID;
            this.dropItemCount = itemCount;
        }
    }
}

