/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model.quest;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.quest.Quest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private static final String[] emptyStrList = new String[0];
    private static final int[] emptyIntList = new int[0];
    public final String name;
    public final Quest quest;
    private HashMap<Integer, ArrayList<L2DropData>> drops;
    private String[] events = emptyStrList;
    private int[] killIds = emptyIntList;
    private int[] talkIds = emptyIntList;

    public State(String name, Quest quest) {
        this.name = name;
        this.quest = quest;
        quest.addState(this);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    String[] getEvents() {
        return this.events;
    }

    int[] getKillIds() {
        return this.killIds;
    }

    public int addKillId(int killId) {
        int len = this.killIds.length;
        int[] tmp = new int[len + 1];
        for (int i = 0; i < len; ++i) {
            tmp[i] = this.killIds[i];
        }
        tmp[len] = killId;
        this.killIds = tmp;
        return killId;
    }

    int[] getTalkIds() {
        return this.talkIds;
    }

    public int addTalkId(int talkId) {
        int len = this.talkIds.length;
        int[] tmp = new int[len + 1];
        for (int i = 0; i < len; ++i) {
            tmp[i] = this.talkIds[i];
        }
        tmp[len] = talkId;
        this.talkIds = tmp;
        return talkId;
    }

    HashMap<Integer, ArrayList<L2DropData>> getDrops() {
        return this.drops;
    }

    public void addQuestDrop(int npcId, int itemId, int chance) {
        try {
            if (this.drops == null) {
                this.drops = new HashMap();
            }
            L2DropData d = new L2DropData();
            d.setItemId(itemId);
            d.setChance(chance);
            d.setQuestID(this.quest.name);
            d.addStates(new String[]{this.name});
            ArrayList<L2DropData> lst = this.drops.get(npcId);
            if (lst != null) {
                lst.add(d);
            } else {
                lst = new ArrayList();
                lst.add(d);
                this.drops.put(npcId, lst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

