/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DateRange {
    private Date startDate;
    private Date endDate;

    public DateRange(Date from, Date to) {
        this.startDate = from;
        this.endDate = to;
    }

    public static DateRange parse(String dateRange, DateFormat format) {
        String[] date = dateRange.split("-");
        if (date.length == 2) {
            try {
                Date start = format.parse(date[0]);
                Date end = format.parse(date[1]);
                return new DateRange(start, end);
            }
            catch (ParseException e) {
                System.err.println("Invalid Date Format.");
                e.printStackTrace();
            }
        }
        return new DateRange(null, null);
    }

    public boolean isValid() {
        return this.startDate == null || this.endDate == null;
    }

    public boolean isWithinRange(Date date) {
        return date.after(this.startDate) && date.before(this.endDate);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }
}

