/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.l2j.gameserver.script.ScriptDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptPackage {
    private ArrayList<ScriptDocument> scriptFiles = new ArrayList();
    private ArrayList<String> otherFiles = new ArrayList();
    private String name;

    public ScriptPackage(ZipFile pack) {
        this.name = pack.getName();
        this.addFiles(pack);
    }

    public ArrayList<String> getOtherFiles() {
        return this.otherFiles;
    }

    public List<ScriptDocument> getScriptFiles() {
        return this.scriptFiles;
    }

    private void addFiles(ZipFile pack) {
        Enumeration<? extends ZipEntry> e = pack.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.getName().endsWith(".xml")) {
                try {
                    ScriptDocument newScript = new ScriptDocument(entry.getName(), pack.getInputStream(entry));
                    this.scriptFiles.add(newScript);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            if (entry.isDirectory()) continue;
            this.otherFiles.add(entry.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.getScriptFiles().isEmpty() && this.getOtherFiles().isEmpty()) {
            return "Empty Package.";
        }
        String out = "Package Name: " + this.getName() + "\n";
        if (!this.getScriptFiles().isEmpty()) {
            out = out + "Xml Script Files...\n";
            for (ScriptDocument script : this.getScriptFiles()) {
                out = out + script.getName() + "\n";
            }
        }
        if (!this.getOtherFiles().isEmpty()) {
            out = out + "Other Files...\n";
            for (String fileName : this.getOtherFiles()) {
                out = out + fileName + "\n";
            }
        }
        return out;
    }
}

