/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.script.faenor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GameServer;
import net.sf.l2j.gameserver.script.Parser;
import net.sf.l2j.gameserver.script.ParserNotCreatedException;
import net.sf.l2j.gameserver.script.ScriptDocument;
import net.sf.l2j.gameserver.script.ScriptEngine;
import net.sf.l2j.gameserver.script.ScriptPackage;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.w3c.dom.Node;

public class FaenorScriptEngine
extends ScriptEngine {
    static Logger _log = Logger.getLogger(GameServer.class.getName());
    public static final String PACKAGE_DIRECTORY = "data/script/";
    public static final boolean DEBUG = true;
    private LinkedList<ScriptDocument> scripts = new LinkedList();

    public FaenorScriptEngine() {
        this.loadPackages();
        this.parsePackages();
    }

    public void reloadPackages() {
        this.scripts = new LinkedList();
        this.parsePackages();
    }

    private void loadPackages() {
        File packDirectory = new File(Config.DATAPACK_ROOT, PACKAGE_DIRECTORY);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".zip");
            }
        };
        File[] files = packDirectory.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            ZipFile zipPack;
            try {
                zipPack = new ZipFile(files[i]);
            }
            catch (ZipException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            ScriptPackage module = new ScriptPackage(zipPack);
            List<ScriptDocument> scripts = module.getScriptFiles();
            for (ScriptDocument script : scripts) {
                this.scripts.add(script);
            }
        }
    }

    public void orderScripts() {
        if (this.scripts.size() > 1) {
            int i = 0;
            while (i < this.scripts.size()) {
                if (this.scripts.get(i).getName().contains("NpcStatData")) {
                    this.scripts.addFirst(this.scripts.remove(i));
                    continue;
                }
                ++i;
            }
        }
    }

    public void parsePackages() {
        BSFManager context2 = new BSFManager();
        try {
            context2.eval("beanshell", "core", 0, 0, "double log1p(double d) { return Math.log1p(d); }");
            context2.eval("beanshell", "core", 0, 0, "double pow(double d, double p) { return Math.pow(d,p); }");
            for (ScriptDocument script : this.scripts) {
                this.parseScript(script, context2);
            }
        }
        catch (BSFException e) {
            e.printStackTrace();
        }
    }

    public void parseScript(ScriptDocument script, BSFManager context2) {
        _log.fine("Parsing Script: " + script.getName());
        Node node = script.getDocument().getFirstChild();
        String parserClass = "faenor.Faenor" + node.getNodeName() + "Parser";
        Parser parser = null;
        try {
            parser = FaenorScriptEngine.createParser(parserClass);
        }
        catch (ParserNotCreatedException e) {
            _log.warning("ERROR: No parser registered for Script: " + parserClass);
            e.printStackTrace();
        }
        if (parser == null) {
            _log.warning("Unknown Script Type: " + script.getName());
            return;
        }
        try {
            parser.parseScript(node, context2);
            _log.fine(script.getName() + "Script Sucessfullty Parsed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.warning("Script Parsing Failed.");
        }
    }

    public String toString() {
        if (this.scripts.isEmpty()) {
            return "No Packages Loaded.";
        }
        String out = "Script Packages currently loaded:\n";
        for (ScriptDocument script : this.scripts) {
            out = out + script;
        }
        return out;
    }
}

