/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class Attack
extends ServerBasePacket {
    private static final String _S__06_ATTACK = "[S] 06 Attack";
    public final int _attackerId;
    public final boolean _soulshot;
    private int _x;
    private int _y;
    private int _z;
    private Hit[] hits;

    public Attack(L2Character attacker, boolean ss) {
        this._attackerId = attacker.getObjectId();
        this._soulshot = ss;
        this._x = attacker.getX();
        this._y = attacker.getY();
        this._z = attacker.getZ();
        this.hits = new Hit[0];
    }

    public void addHit(L2Object target, int damage, boolean miss, boolean crit, boolean shld) {
        int pos = this.hits.length;
        Hit[] tmp = new Hit[pos + 1];
        for (int i = 0; i < this.hits.length; ++i) {
            tmp[i] = this.hits[i];
        }
        tmp[pos] = new Hit(target, damage, miss, crit, shld);
        this.hits = tmp;
    }

    public boolean hasHits() {
        return this.hits.length > 0;
    }

    final void runImpl() {
    }

    final void writeImpl() {
        this.writeC(5);
        this.writeD(this._attackerId);
        this.writeD(this.hits[0]._targetId);
        this.writeD(this.hits[0]._damage);
        this.writeC(this.hits[0]._flags);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeH(this.hits.length - 1);
        for (int i = 1; i < this.hits.length; ++i) {
            this.writeD(this.hits[i]._targetId);
            this.writeD(this.hits[i]._damage);
            this.writeC(this.hits[i]._flags);
        }
    }

    public String getType() {
        return _S__06_ATTACK;
    }

    private class Hit {
        int _targetId;
        int _damage;
        int _flags;

        Hit(L2Object target, int damage, boolean miss, boolean crit, boolean shld) {
            this._targetId = target.getObjectId();
            this._damage = damage;
            if (Attack.this._soulshot) {
                this._flags |= 0x10;
            }
            if (crit) {
                this._flags |= 0x20;
            }
            if (shld) {
                this._flags |= 0x40;
            }
            if (miss) {
                this._flags |= 0x80;
            }
        }
    }
}

