/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuyList
extends ServerBasePacket {
    private static final String _S__1D_BUYLIST = "[S] 11 BuyList";
    private int _listId;
    private L2ItemInstance[] _list;
    private int _money;

    public BuyList(L2TradeList list, int currentMoney) {
        this._listId = list.getListId();
        ArrayList<L2ItemInstance> lst = list.getItems();
        this._list = lst.toArray(new L2ItemInstance[lst.size()]);
        this._money = currentMoney;
    }

    public BuyList(ArrayList<L2ItemInstance> lst, int listId, int currentMoney) {
        this._listId = listId;
        this._list = lst.toArray(new L2ItemInstance[lst.size()]);
        this._money = currentMoney;
    }

    @Override
    final void runImpl() {
    }

    @Override
    final void writeImpl() {
        this.writeC(17);
        this.writeD(this._money);
        this.writeD(this._listId);
        this.writeH(this._list.length);
        for (L2ItemInstance item : this._list) {
            this.writeH(item.getItem().getType1());
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeD(0);
            this.writeH(item.getItem().getType2());
            this.writeH(0);
            if (item.getItem().getType1() != 4) {
                this.writeD(item.getItem().getBodyPart());
                this.writeH(item.getEnchantLevel());
                this.writeH(0);
                this.writeH(0);
            } else {
                this.writeD(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
            }
            this.writeD(item.getPriceToSell());
        }
    }

    @Override
    public String getType() {
        return _S__1D_BUYLIST;
    }
}

