/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.CharSelectInfoPackage;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class CharSelectInfo
extends ServerBasePacket {
    private static final String _S__1F_CHARSELECTINFO = "[S] 1F CharSelectInfo";
    private static Logger _log = Logger.getLogger(CharSelectInfo.class.getName());
    private String _loginName;
    private int _sessionId;
    private CharSelectInfoPackage[] _characterPackages;

    public CharSelectInfo(String loginName, int sessionId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = this.loadCharacterSelectInfo();
    }

    public CharSelectInfoPackage[] getCharInfo() {
        return this._characterPackages;
    }

    final void runImpl() {
    }

    final void writeImpl() {
        int i;
        int size = this._characterPackages.length;
        this.writeC(19);
        this.writeD(size);
        long lastAccess = 0L;
        int lastUsed = -1;
        for (i = 0; i < size; ++i) {
            if (lastAccess >= this._characterPackages[i].getLastAccess()) continue;
            lastAccess = this._characterPackages[i].getLastAccess();
            lastUsed = i;
        }
        for (i = 0; i < size; ++i) {
            CharSelectInfoPackage charInfoPackage = this._characterPackages[i];
            this.writeS(charInfoPackage.getName());
            this.writeD(charInfoPackage.getCharId());
            this.writeS(this._loginName);
            this.writeD(this._sessionId);
            this.writeD(charInfoPackage.getClanId());
            this.writeD(0);
            this.writeD(charInfoPackage.getSex());
            this.writeD(charInfoPackage.getRace());
            this.writeD(charInfoPackage.getClassId());
            this.writeD(1);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeF(charInfoPackage.getCurrentHp());
            this.writeF(charInfoPackage.getCurrentMp());
            this.writeD(charInfoPackage.getSp());
            this.writeD(charInfoPackage.getExp());
            this.writeD(charInfoPackage.getLevel());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(charInfoPackage.getPaperdollObjectId(0));
            this.writeD(charInfoPackage.getPaperdollObjectId(2));
            this.writeD(charInfoPackage.getPaperdollObjectId(1));
            this.writeD(charInfoPackage.getPaperdollObjectId(3));
            this.writeD(charInfoPackage.getPaperdollObjectId(5));
            this.writeD(charInfoPackage.getPaperdollObjectId(4));
            this.writeD(charInfoPackage.getPaperdollObjectId(6));
            this.writeD(charInfoPackage.getPaperdollObjectId(7));
            this.writeD(charInfoPackage.getPaperdollObjectId(8));
            this.writeD(charInfoPackage.getPaperdollObjectId(9));
            this.writeD(charInfoPackage.getPaperdollObjectId(10));
            this.writeD(charInfoPackage.getPaperdollObjectId(11));
            this.writeD(charInfoPackage.getPaperdollObjectId(12));
            this.writeD(charInfoPackage.getPaperdollObjectId(13));
            this.writeD(charInfoPackage.getPaperdollObjectId(14));
            this.writeD(charInfoPackage.getPaperdollObjectId(15));
            this.writeD(charInfoPackage.getPaperdollItemId(0));
            this.writeD(charInfoPackage.getPaperdollItemId(2));
            this.writeD(charInfoPackage.getPaperdollItemId(1));
            this.writeD(charInfoPackage.getPaperdollItemId(3));
            this.writeD(charInfoPackage.getPaperdollItemId(5));
            this.writeD(charInfoPackage.getPaperdollItemId(4));
            this.writeD(charInfoPackage.getPaperdollItemId(6));
            this.writeD(charInfoPackage.getPaperdollItemId(7));
            this.writeD(charInfoPackage.getPaperdollItemId(8));
            this.writeD(charInfoPackage.getPaperdollItemId(9));
            this.writeD(charInfoPackage.getPaperdollItemId(10));
            this.writeD(charInfoPackage.getPaperdollItemId(11));
            this.writeD(charInfoPackage.getPaperdollItemId(12));
            this.writeD(charInfoPackage.getPaperdollItemId(13));
            this.writeD(charInfoPackage.getPaperdollItemId(14));
            this.writeD(charInfoPackage.getPaperdollItemId(15));
            this.writeD(charInfoPackage.getHairStyle());
            this.writeD(charInfoPackage.getHairColor());
            this.writeD(charInfoPackage.getFace());
            this.writeF(charInfoPackage.getMaxHp());
            this.writeF(charInfoPackage.getMaxMp());
            this.writeD(charInfoPackage.getDeleteTimer());
            this.writeD(charInfoPackage.getClassId());
            if (i == lastUsed) {
                this.writeD(1);
            } else {
                this.writeD(0);
            }
            this.writeC(charInfoPackage.getEnchantEffect());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSelectInfoPackage[] loadCharacterSelectInfo() {
        ArrayList<CharSelectInfoPackage> characterList = new ArrayList<CharSelectInfoPackage>();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT account_name, obj_Id, char_name, level, maxHp, curHp, maxMp, curMp, acc, crit, evasion, mAtk, mDef, mSpd, pAtk, pDef, pSpd, runSpd, walkSpd, str, con, dex, _int, men, wit, face, hairStyle, hairColor, sex, heading, x, y, z, movement_multiplier, attack_speed_multiplier, colRad, colHeight, exp, sp, karma, pvpkills, pkkills, clanid, maxload, race, classid, deletetime, cancraft, title, allyId, rec_have, rec_left, accesslevel, online, char_slot, lastAccess FROM characters WHERE account_name=? ORDER BY char_name");
            statement.setString(1, this._loginName);
            ResultSet charList = statement.executeQuery();
            while (charList.next()) {
                CharSelectInfoPackage charInfopackage = this.restoreChar(charList);
                characterList.add(charInfopackage);
            }
            charList.close();
            statement.close();
            CharSelectInfoPackage[] charSelectInfoPackageArray = characterList.toArray(new CharSelectInfoPackage[characterList.size()]);
            return charSelectInfoPackageArray;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not restore charinfo:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    private CharSelectInfoPackage restoreChar(ResultSet chardata) {
        CharSelectInfoPackage charInfopackage = null;
        try {
            int objectId = chardata.getInt("obj_id");
            String name = chardata.getString("char_name");
            charInfopackage = new CharSelectInfoPackage(objectId, name);
            charInfopackage.setLevel(chardata.getInt("level"));
            charInfopackage.setMaxHp(chardata.getInt("maxhp"));
            charInfopackage.setCurrentHp(chardata.getDouble("curhp"));
            charInfopackage.setMaxMp(chardata.getInt("maxmp"));
            charInfopackage.setCurrentMp(chardata.getDouble("curmp"));
            charInfopackage.setFace(chardata.getInt("face"));
            charInfopackage.setHairStyle(chardata.getInt("hairstyle"));
            charInfopackage.setHairColor(chardata.getInt("haircolor"));
            charInfopackage.setSex(chardata.getInt("sex"));
            charInfopackage.setExp(chardata.getInt("exp"));
            charInfopackage.setSp(chardata.getInt("sp"));
            charInfopackage.setClanId(chardata.getInt("clanid"));
            charInfopackage.setRace(chardata.getInt("race"));
            charInfopackage.setClassId(chardata.getInt("classid"));
            charInfopackage.setDeleteTimer(chardata.getInt("deletetime"));
            charInfopackage.setLastAccess(chardata.getLong("lastAccess"));
        }
        catch (Exception e) {
            _log.log(Level.INFO, "", e);
        }
        return charInfopackage;
    }

    public String getType() {
        return _S__1F_CHARSELECTINFO;
    }
}

