/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetInventoryUpdate
extends ServerBasePacket {
    private static Logger _log = Logger.getLogger(InventoryUpdate.class.getName());
    private static final String _S__37_INVENTORYUPDATE = "[S] b3 InventoryUpdate";
    private ArrayList<L2ItemInstance> _items;
    private boolean _showWindow;

    public PetInventoryUpdate() {
        this._items = new ArrayList();
    }

    public PetInventoryUpdate(ArrayList<L2ItemInstance> items) {
        this._items = items;
    }

    public void addNewItem(L2ItemInstance item) {
        item.setLastChange(1);
        this._items.add(item);
    }

    public void addModifiedItem(L2ItemInstance item) {
        item.setLastChange(2);
        this._items.add(item);
    }

    public void addRemovedItem(L2ItemInstance item) {
        item.setLastChange(3);
        this._items.add(item);
    }

    @Override
    final void runImpl() {
        if (Config.DEBUG) {
            for (L2ItemInstance temp : this._items) {
                _log.fine("oid:" + Integer.toHexString(temp.getObjectId()) + " item:" + temp.getItem().getName() + " last change:" + temp.getLastChange());
            }
        }
    }

    @Override
    final void writeImpl() {
        this.writeC(179);
        int count = this._items.size();
        this.writeH(count);
        for (L2ItemInstance temp : this._items) {
            this.writeH(temp.getLastChange());
            this.writeH(temp.getItem().getType1());
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(0);
            if (temp.isEquipped()) {
                this.writeH(1);
            } else {
                this.writeH(0);
            }
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__37_INVENTORYUPDATE;
    }
}

