/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.templates.L2Item;

public class PrivateBuyListBuy
extends ServerBasePacket {
    private static final String _S__D1_PRIVATEBUYLISTBUY = "[S] b8 PrivateBuyListBuy";
    private L2PcInstance _buyer;
    private L2PcInstance _seller;
    private int _sellerAdena;
    private ArrayList<TradeItem> _buyerslist;
    private ArrayList<TradeItem> _sellerslist;

    public PrivateBuyListBuy(L2PcInstance buyer, L2PcInstance seller) {
        this._buyer = buyer;
        this._seller = seller;
    }

    final void runImpl() {
        this._sellerAdena = this._seller.getAdena();
        L2ItemInstance[] sellerItems = this._seller.getInventory().getItems();
        this._buyerslist = this._buyer.getBuyList();
        this._sellerslist = new ArrayList(this._buyerslist.size());
        int count = this._buyerslist.size();
        for (int i = 0; i < count; ++i) {
            TradeItem temp3;
            TradeItem temp2 = this._buyerslist.get(i);
            boolean add2 = false;
            for (L2ItemInstance item : sellerItems) {
                if (temp2.getItemId() != item.getItemId()) continue;
                temp3 = new TradeItem();
                temp3.setCount(item.getCount());
                temp3.setItemId(item.getItemId());
                temp3.setObjectId(item.getObjectId());
                temp2.setObjectId(item.getObjectId());
                temp3.setOwnersPrice(temp2.getOwnersPrice());
                temp3.setstorePrice(temp2.getOwnersPrice());
                if (this._sellerslist.contains(temp3)) break;
                this._sellerslist.add(temp3);
                add2 = true;
                break;
            }
            if (add2) continue;
            temp3 = new TradeItem();
            temp3.setCount(0);
            temp3.setItemId(temp2.getItemId());
            temp3.setOwnersPrice(temp2.getOwnersPrice());
            this._sellerslist.add(temp3);
        }
    }

    final void writeImpl() {
        this.writeC(184);
        this.writeD(this._buyer.getObjectId());
        this.writeD(this._sellerAdena);
        int count = this._sellerslist.size();
        this.writeD(count);
        for (int i = 0; i < count; ++i) {
            TradeItem temp2 = this._buyerslist.get(i);
            TradeItem temp3 = this._sellerslist.get(i);
            L2Item tempItem3 = ItemTable.getInstance().getTemplate(temp3.getItemId());
            int buyCount = temp2.getCount();
            int sellCount = temp3.getCount();
            this.writeD(temp3.getObjectId());
            this.writeD(temp3.getItemId());
            this.writeH(temp3.getEnchantLevel());
            if (sellCount > buyCount) {
                this.writeD(buyCount);
            } else {
                this.writeD(sellCount);
            }
            this.writeD(temp3.getStorePrice());
            this.writeH(0);
            this.writeD(tempItem3.getBodyPart());
            this.writeH(tempItem3.getType2());
            this.writeD(temp3.getOwnersPrice());
            if (buyCount > sellCount) {
                this.writeD(sellCount);
                continue;
            }
            this.writeD(buyCount);
        }
    }

    public String getType() {
        return _S__D1_PRIVATEBUYLISTBUY;
    }
}

