/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2MerchantInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.templates.L2Item;

public class PrivateBuyListSell
extends ServerBasePacket {
    private static final String _S__B4_PRIVATEBUYLISTSELL = "[S] 9b PrivateBuyListSell";
    private final L2Character _seller;
    private final int _buyerAdena;
    private ArrayList<TradeItem> _sellList;
    private final boolean exchangeWithLeaseHolder;

    public PrivateBuyListSell(L2PcInstance buyer, L2PcInstance seller) {
        this._seller = seller;
        this._buyerAdena = buyer.getAdena();
        this.exchangeWithLeaseHolder = false;
    }

    public PrivateBuyListSell(L2PcInstance buyer, L2MerchantInstance seller) {
        this._seller = seller;
        this._buyerAdena = buyer.getAdena();
        this.exchangeWithLeaseHolder = buyer.getObjectId() == seller.getLeaseHolderId();
    }

    final void runImpl() {
        if (this._seller instanceof L2PcInstance) {
            L2PcInstance seller = (L2PcInstance)this._seller;
            this._sellList = seller.getSellList();
            Iterator<TradeItem> i = this._sellList.iterator();
            while (i.hasNext()) {
                TradeItem ti = i.next();
                L2ItemInstance inst = seller.getInventory().getItemByObjectId(ti.getObjectId());
                if (inst == null) {
                    i.remove();
                    continue;
                }
                if (inst.getCount() < ti.getCount()) {
                    ti.setCount(inst.getCount());
                }
                if (ti.getCount() <= 0) {
                    i.remove();
                    continue;
                }
                ti.setEnchantLevel(inst.getEnchantLevel());
            }
        } else {
            L2MerchantInstance seller = (L2MerchantInstance)this._seller;
            this._sellList = new ArrayList();
            for (L2ItemInstance inst : seller.listLeaseItems()) {
                if (inst.getCount() <= 0) continue;
                TradeItem ti = new TradeItem();
                ti.setObjectId(inst.getObjectId());
                ti.setItemId(inst.getItemId());
                ti.setOwnersPrice(this.exchangeWithLeaseHolder ? 0 : inst.getPriceToSell());
                ti.setCount(inst.getCount());
                ti.setEnchantLevel(inst.getEnchantLevel());
                this._sellList.add(ti);
            }
            if (this.exchangeWithLeaseHolder) {
                L2ItemInstance inst = seller.getLeaseAdena();
                TradeItem ti = new TradeItem();
                ti.setObjectId(inst.getObjectId());
                ti.setItemId(inst.getItemId());
                ti.setOwnersPrice(0);
                ti.setCount(inst.getCount());
                ti.setEnchantLevel(inst.getEnchantLevel());
                this._sellList.add(ti);
            }
        }
    }

    final void writeImpl() {
        this.writeC(155);
        this.writeD(this._seller.getObjectId());
        this.writeD(this._buyerAdena);
        this.writeD(this._sellList.size());
        for (TradeItem ti : this._sellList) {
            L2Item tempItem = ItemTable.getInstance().getTemplate(ti.getItemId());
            this.writeD(tempItem.getType2());
            this.writeD(ti.getObjectId());
            this.writeD(ti.getItemId());
            this.writeD(ti.getCount());
            this.writeH(0);
            this.writeH(ti.getEnchantLevel());
            this.writeH(0);
            this.writeD(tempItem.getBodyPart());
            this.writeD(ti.getOwnersPrice());
            this.writeD(ti.getStorePrice());
        }
    }

    public String getType() {
        return _S__B4_PRIVATEBUYLISTSELL;
    }
}

