/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.templates.L2Item;

public class PrivateSellListSell
extends ServerBasePacket {
    private static final String _S__B3_PRIVATESELLLISTSELL = "[S] 9a PrivateSellListSell";
    private L2PcInstance _seller;
    private int _sellerAdena;
    private L2TradeList _list;
    private ArrayList<TradeItem> _sellList;

    public PrivateSellListSell(L2PcInstance seller) {
        this._seller = seller;
    }

    final void runImpl() {
        this._sellerAdena = this._seller.getAdena();
        L2ItemInstance[] inventory = this._seller.getInventory().getItems();
        this._list = new L2TradeList(0);
        this._sellList = this._seller.getSellList();
        int count = this._seller.getInventory().getSize();
        for (int i = 0; i < count; ++i) {
            L2ItemInstance item = inventory[i];
            if (item.isEquipped() || item.getItem().getType2() == 3 || item.getItem().getType2() == 4 && item.getItem().getType1() == 4 || item.isEquipped()) continue;
            this._list.addItem(item);
        }
        if (this._sellList.size() != 0) {
            for (TradeItem temp2 : this._sellList) {
                this._list.removeItem(temp2.getObjectId(), temp2.getCount());
            }
        }
    }

    final void writeImpl() {
        this.writeC(154);
        this.writeD(this._seller.getObjectId());
        this.writeD(this._sellerAdena);
        int count = this._list.getItems().size();
        this.writeD(count);
        for (int i = 0; i < count; ++i) {
            L2ItemInstance temp = this._list.getItems().get(i);
            this.writeD(temp.getItem().getType2());
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getCount());
            this.writeH(0);
            this.writeH(temp.getEnchantLevel());
            this.writeH(0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeD(temp.getPriceToBuy());
        }
        count = this._sellList.size();
        this.writeD(count);
        if (count != 0) {
            for (TradeItem temp2 : this._sellList) {
                L2Item tempItem = ItemTable.getInstance().getTemplate(temp2.getItemId());
                this.writeD(tempItem.getType2());
                this.writeD(temp2.getObjectId());
                this.writeD(temp2.getItemId());
                this.writeD(temp2.getCount());
                this.writeH(0);
                this.writeH(temp2.getEnchantLevel());
                this.writeH(0);
                this.writeD(tempItem.getBodyPart());
                this.writeD(temp2.getOwnersPrice());
                this.writeD(temp2.getStorePrice());
            }
        }
    }

    public String getType() {
        return _S__B3_PRIVATESELLLISTSELL;
    }
}

