/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.serverpackets;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public class WareHouseDepositList
extends ServerBasePacket {
    private static Logger _log = Logger.getLogger(WareHouseDepositList.class.getName());
    private static final String _S__53_WAREHOUSEDEPOSITLIST = "[S] 41 WareHouseDepositList";
    private L2PcInstance _cha;
    private int _money;
    private L2ItemInstance[] _itemslist;

    public WareHouseDepositList(L2PcInstance cha) {
        this._cha = cha;
        this._money = cha.getAdena();
    }

    final void runImpl() {
        ArrayList<L2ItemInstance> itemlist = new ArrayList<L2ItemInstance>();
        for (L2ItemInstance item : this._cha.getInventory().getItems()) {
            if (item.isEquipped() || item.getItem().getType2() == 3) continue;
            itemlist.add(item);
            if (!Config.DEBUG) continue;
            _log.fine("item:" + item.getItem().getName() + " type1:" + item.getItem().getType1() + " type2:" + item.getItem().getType2());
        }
        this._itemslist = itemlist.toArray(new L2ItemInstance[itemlist.size()]);
        if (Config.DEBUG) {
            _log.fine("count:" + itemlist.size());
        }
    }

    final void writeImpl() {
        this.writeC(65);
        this.writeD(this._money);
        int count = this._itemslist.length;
        if (Config.DEBUG) {
            _log.fine("count:" + count);
        }
        this.writeH(count);
        for (int i = 0; i < count; ++i) {
            L2ItemInstance temp = this._itemslist[i];
            this.writeH(temp.getItem().getType1());
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(100);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(300);
            this.writeH(200);
            this.writeD(temp.getItemId());
        }
    }

    public String getType() {
        return _S__53_WAREHOUSEDEPOSITLIST;
    }
}

