/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.l2j.gameserver.Item;
import net.sf.l2j.gameserver.skills.DocumentBase;
import net.sf.l2j.gameserver.templates.L2Armor;
import net.sf.l2j.gameserver.templates.L2ArmorType;
import net.sf.l2j.gameserver.templates.L2EtcItem;
import net.sf.l2j.gameserver.templates.L2EtcItemType;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.gameserver.templates.StatsSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocumentItem
extends DocumentBase {
    private Item currentItem = null;
    private List<L2Item> itemsInFile = new LinkedList<L2Item>();
    private Map<Integer, Item> itemData = new HashMap<Integer, Item>();

    public DocumentItem(HashMap<Integer, Item> itemData, File file) {
        super(file);
        this.itemData = itemData;
    }

    private void setCurrentItem(Item item) {
        this.currentItem = item;
    }

    @Override
    protected StatsSet getStatsSet() {
        return this.currentItem.set;
    }

    @Override
    protected Number getTableValue(String name) {
        return ((Number[])this.tables.get(name))[this.currentItem.currentLevel];
    }

    @Override
    protected Number getTableValue(String name, int idx) {
        return ((Number[])this.tables.get(name))[idx - 1];
    }

    @Override
    protected void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    this.setCurrentItem(new Item());
                    this.parseItem(d);
                    this.itemsInFile.add(this.currentItem.item);
                    this.resetTable();
                }
                continue;
            }
            if (!"item".equalsIgnoreCase(n.getNodeName())) continue;
            this.setCurrentItem(new Item());
            this.parseItem(n);
            this.itemsInFile.add(this.currentItem.item);
        }
    }

    protected void parseItem(Node n) {
        Node first;
        int itemId = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
        String itemName = n.getAttributes().getNamedItem("name").getNodeValue();
        this.currentItem.id = itemId;
        this.currentItem.name = itemName;
        this.currentItem.set = this.itemData.get((Object)Integer.valueOf((int)this.currentItem.id)).set;
        this.currentItem.type = this.itemData.get((Object)Integer.valueOf((int)this.currentItem.id)).type;
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"table".equalsIgnoreCase(n.getNodeName())) continue;
            this.parseTable(n);
        }
        for (n = first; n != null; n = n.getNextSibling()) {
            if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
            this.parseBeanSet(n, this.itemData.get((Object)Integer.valueOf((int)this.currentItem.id)).set, 1);
        }
        for (n = first; n != null; n = n.getNextSibling()) {
            if (!"for".equalsIgnoreCase(n.getNodeName())) continue;
            this.makeItem();
            this.parseTemplate(n, this.currentItem.item);
        }
    }

    private void makeItem() {
        if (this.currentItem.item != null) {
            return;
        }
        if (this.currentItem.type instanceof L2ArmorType) {
            this.currentItem.item = new L2Armor((L2ArmorType)this.currentItem.type, this.currentItem.set);
        } else if (this.currentItem.type instanceof L2WeaponType) {
            this.currentItem.item = new L2Weapon((L2WeaponType)this.currentItem.type, this.currentItem.set);
        } else if (this.currentItem.type instanceof L2EtcItemType) {
            this.currentItem.item = new L2EtcItem((L2EtcItemType)this.currentItem.type, this.currentItem.set);
        } else {
            throw new Error("Unknown item type " + this.currentItem.type);
        }
    }

    public List<L2Item> getItemList() {
        return this.itemsInFile;
    }
}

