/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.util.ArrayList;
import java.util.Random;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;

final class EffectConfuseMob
extends L2Effect {
    public EffectConfuseMob(Env env, EffectTemplate template) {
        super(env, template);
    }

    public L2Effect.EffectType getEffectType() {
        return L2Effect.EffectType.CONFUSE_MOB_ONLY;
    }

    public void onStart() {
        this.getEffected().startConfused();
        this.onActionTime();
    }

    public void onExit() {
        this.getEffected().stopConfused(this);
    }

    public boolean onActionTime() {
        ArrayList<L2Character> targetList = new ArrayList<L2Character>();
        L2Object[] possibleTargets = L2World.getInstance().getVisibleObjects(this.getEffected(), 500);
        for (int i = 0; i < possibleTargets.length; ++i) {
            if (!(possibleTargets[i] instanceof L2Attackable) || possibleTargets[i] == this.getEffected()) continue;
            targetList.add((L2Character)possibleTargets[i]);
        }
        if (targetList.size() == 0) {
            return true;
        }
        int nextTargetIdx = new Random().nextInt(targetList.size());
        L2Object target = (L2Object)targetList.get(nextTargetIdx);
        this.getEffected().setTarget(target);
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        return true;
    }
}

