/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;

final class EffectFear
extends L2Effect {
    public static final int FEAR_RANGE = 500;

    public EffectFear(Env env, EffectTemplate template) {
        super(env, template);
    }

    public L2Effect.EffectType getEffectType() {
        return L2Effect.EffectType.FEAR;
    }

    public void onStart() {
        this.getEffected().startFear();
        this.onActionTime();
    }

    public void onExit() {
        this.getEffected().stopFear(this);
    }

    public boolean onActionTime() {
        int posX = this.getEffected().getX();
        int posY = this.getEffected().getY();
        int posZ = this.getEffected().getZ();
        int signx = -1;
        int signy = -1;
        if (this.getEffected().getX() > this.getEffector().getX()) {
            signx = 1;
        }
        if (this.getEffected().getY() > this.getEffector().getY()) {
            signy = 1;
        }
        this.getEffected().setRunning();
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(posX += signx * 500, posY += signy * 500, posZ, 0));
        return true;
    }
}

