/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;

class EffectRelax
extends L2Effect {
    public EffectRelax(Env env, EffectTemplate template) {
        super(env, template);
    }

    public L2Effect.EffectType getEffectType() {
        return L2Effect.EffectType.RELAXING;
    }

    public void onStart() {
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
        super.onStart();
    }

    public void onExit() {
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        super.onExit();
    }

    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        if (!((L2PcInstance)this.getEffected()).isSitting()) {
            return false;
        }
        if (this.getEffected().getCurrentHp() + 1.0 > (double)this.getEffected().getMaxHp() && this.getSkill().isToggle()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Fully rested. Effect of " + this.getSkill().getName() + " has been removed.");
            this.getEffected().sendPacket(sm);
            if (this.getEffected() instanceof L2PcInstance) {
                ((L2PcInstance)this.getEffected()).standUp();
            }
            return false;
        }
        double manaDam = this.calc();
        if (manaDam > this.getEffected().getCurrentMp() && this.getSkill().isToggle()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Not enough mana. Effect of " + this.getSkill().getName() + " has been removed.");
            this.getEffected().sendPacket(sm);
            if (this.getEffected() instanceof L2PcInstance) {
                ((L2PcInstance)this.getEffected()).standUp();
            }
            return false;
        }
        this.getEffected().reduceCurrentMp(manaDam);
        return true;
    }
}

