/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;

final class EffectSilentMove
extends L2Effect {
    public EffectSilentMove(Env env, EffectTemplate template) {
        super(env, template);
    }

    public void onStart() {
        super.onStart();
        L2Character effected = this.getEffected();
        if (effected instanceof L2PcInstance) {
            ((L2PcInstance)effected).setSilentMoving(true);
        }
    }

    public void onExit() {
        super.onExit();
        L2Character effected = this.getEffected();
        if (effected instanceof L2PcInstance) {
            ((L2PcInstance)effected).setSilentMoving(false);
        }
    }

    public L2Effect.EffectType getEffectType() {
        return L2Effect.EffectType.SILENT_MOVE;
    }

    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        double manaDam = this.calc();
        if (manaDam > this.getEffected().getCurrentMp()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Not enough mana. Effect of " + this.getSkill().getName() + " has been removed.");
            this.getEffected().sendPacket(sm);
            return false;
        }
        this.getEffected().reduceCurrentMp(manaDam);
        return true;
    }
}

