/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.skills.Condition;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.skills.Lambda;

public final class EffectTemplate {
    private final Class _func;
    private final Constructor _constructor;
    public final Condition _attachCond;
    public final Condition _applayCond;
    public final Lambda _lambda;
    public final int _counter;
    public final int _period;
    public final short _abnormalEffect;
    public FuncTemplate[] _funcTemplates;
    public final String _stackType;
    public final int _stackOrder;

    public EffectTemplate(Condition attachCond, Condition applayCond, String func, Lambda lambda, int counter, int period, short abnormalEffect, String stackType, int stackOrder) {
        this._attachCond = attachCond;
        this._applayCond = applayCond;
        this._lambda = lambda;
        this._counter = counter;
        this._period = period;
        this._abnormalEffect = abnormalEffect;
        this._stackType = stackType;
        this._stackOrder = stackOrder;
        try {
            this._func = Class.forName("net.sf.l2j.gameserver.skills.Effect" + func);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            this._constructor = this._func.getConstructor(Env.class, EffectTemplate.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public L2Effect getEffect(Env env) {
        if (this._attachCond != null && !this._attachCond.test(env)) {
            return null;
        }
        try {
            L2Effect effect = (L2Effect)this._constructor.newInstance(env, this);
            return effect;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new FuncTemplate[]{f};
        } else {
            int len = this._funcTemplates.length;
            FuncTemplate[] tmp = new FuncTemplate[len + 1];
            System.arraycopy(this._funcTemplates, 0, tmp, 0, len);
            tmp[len] = f;
            this._funcTemplates = tmp;
        }
    }
}

