/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.EffectCharge;
import net.sf.l2j.gameserver.skills.Formulas;
import net.sf.l2j.gameserver.templates.StatsSet;

public class L2SkillChargeDmg
extends L2Skill {
    final int num_charges;
    final int charge_skill_id;

    public L2SkillChargeDmg(StatsSet set2) {
        super(set2);
        this.num_charges = set2.getInteger("num_charges", this.getLevel());
        this.charge_skill_id = set2.getInteger("charge_skill_id");
    }

    public boolean checkCondition(L2Character activeChar) {
        L2PcInstance player;
        EffectCharge e;
        if (activeChar instanceof L2PcInstance && ((e = (EffectCharge)(player = (L2PcInstance)activeChar).getEffect(this.charge_skill_id)) == null || e.num_charges < this.num_charges)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Not enough charges.");
            activeChar.sendPacket(sm);
            return false;
        }
        return super.checkCondition(activeChar);
    }

    public void useSkill(L2Character caster, L2Object[] targets) {
        if (caster.isAlikeDead()) {
            return;
        }
        EffectCharge effect = (EffectCharge)caster.getEffect(this.charge_skill_id);
        if (effect == null || effect.num_charges < this.num_charges) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Not enough charges.");
            caster.sendPacket(sm);
            return;
        }
        effect.num_charges -= this.num_charges;
        if (effect.num_charges <= 0) {
            effect.exit();
        } else {
            caster.updateEffectIcons();
        }
        for (int index = 0; index < targets.length; ++index) {
            SystemMessage sm;
            L2Character target = (L2Character)targets[index];
            if (target.isAlikeDead()) continue;
            boolean dual = caster.isUsingDualWeapon();
            boolean shld = Formulas.getInstance().calcShldUse(caster, target);
            boolean crit = Formulas.getInstance().calcCrit(caster.getCriticalHit(target, this));
            int damage = (int)Formulas.getInstance().calcPhysDam(caster, target, this, shld, crit, dual, false);
            if (damage > 0) {
                target.reduceCurrentHp(damage, caster);
                sm = new SystemMessage(35);
                sm.addNumber(damage);
                caster.sendPacket(sm);
                continue;
            }
            sm = new SystemMessage(43);
            caster.sendPacket(sm);
        }
    }
}

