/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.skills;

import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;
import net.sf.l2j.gameserver.templates.StatsSet;

public class L2SkillDrain
extends L2Skill {
    private float absorbPart;
    private int absorbAbs;

    public L2SkillDrain(StatsSet set2) {
        super(set2);
        this.absorbPart = set2.getFloat("absorbPart", 0.0f);
        this.absorbAbs = set2.getInteger("absorbAbs", 0);
    }

    public void useSkill(L2Character caster, L2Object[] targets) {
        if (caster.isAlikeDead()) {
            return;
        }
        boolean ss = false;
        boolean bss = false;
        for (int index = 0; index < targets.length; ++index) {
            L2Character target = (L2Character)targets[index];
            if (target.isAlikeDead() && this.getTargetType() != L2Skill.SkillTargetType.TARGET_CORPSE_MOB) continue;
            double scale = 1.0;
            L2ItemInstance weaponInst = caster.getActiveWeaponInstance();
            if (weaponInst != null) {
                if (weaponInst.getChargedSpiritshot() == 2) {
                    scale *= 2.0;
                    bss = true;
                    weaponInst.setChargedSpiritshot(0);
                } else if (weaponInst.getChargedSpiritshot() == 1) {
                    scale *= 1.5;
                    ss = true;
                    weaponInst.setChargedSpiritshot(0);
                }
            }
            boolean mcrit = Formulas.getInstance().calcMCrit(caster.getMCriticalHit(target, this));
            int damage = (int)Formulas.getInstance().calcMagicDam(caster, target, this, ss, bss, mcrit);
            double hpAdd = (float)this.absorbAbs + this.absorbPart * (float)damage;
            double hp = caster.getCurrentHp() + (hpAdd *= scale);
            caster.setCurrentHp(hp);
            StatusUpdate suhp = new StatusUpdate(caster.getObjectId());
            suhp.addAttribute(StatusUpdate.CUR_HP, (int)hp);
            caster.sendPacket(suhp);
            target.reduceCurrentHp(damage, caster);
            SystemMessage sm = new SystemMessage(35);
            sm.addNumber(damage);
            caster.sendPacket(sm);
        }
    }
}

