/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.templates;

import java.util.ArrayList;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.templates.L2ArmorType;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.StatsSet;

public final class L2Armor
extends L2Item {
    private final int _avoidModifier;
    private final int _pDef;
    private final int _mDef;
    private final int _mpBonus;
    private final int _hpBonus;

    public L2Armor(L2ArmorType type, StatsSet set2) {
        super(type, set2);
        this._avoidModifier = set2.getInteger("avoid_modify");
        this._pDef = set2.getInteger("p_def");
        this._mDef = set2.getInteger("m_def");
        this._mpBonus = set2.getInteger("mp_bonus", 0);
        this._hpBonus = set2.getInteger("hp_bonus", 0);
    }

    public L2ArmorType getItemType() {
        return (L2ArmorType)this.type;
    }

    public final int getItemMask() {
        return this.getItemType().mask();
    }

    public final int getMDef() {
        return this._mDef;
    }

    public final int getPDef() {
        return this._pDef;
    }

    public final int getAvoidModifier() {
        return this._avoidModifier;
    }

    public final int getMpBonus() {
        return this._mpBonus;
    }

    public final int getHpBonus() {
        return this._hpBonus;
    }

    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        ArrayList<Func> funcs = new ArrayList<Func>();
        if (this._funcTemplates != null) {
            for (FuncTemplate t : this._funcTemplates) {
                Env env = new Env();
                env._player = player;
                env._item = instance;
                Func f = t.getFunc(env, instance);
                if (f == null) continue;
                funcs.add(f);
            }
        }
        return funcs.toArray(new Func[funcs.size()]);
    }
}

