/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.templates;

import java.util.ArrayList;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.skills.EffectTemplate;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.templates.StatsSet;

public abstract class L2Item {
    public static final int TYPE1_WEAPON_RING_EARRING_NECKLACE = 0;
    public static final int TYPE1_SHIELD_ARMOR = 1;
    public static final int TYPE1_ITEM_QUESTITEM_ADENA = 4;
    public static final int TYPE2_WEAPON = 0;
    public static final int TYPE2_SHIELD_ARMOR = 1;
    public static final int TYPE2_ACCESSORY = 2;
    public static final int TYPE2_QUEST = 3;
    public static final int TYPE2_MONEY = 4;
    public static final int TYPE2_OTHER = 5;
    public static final int SLOT_NONE = 0;
    public static final int SLOT_UNDERWEAR = 1;
    public static final int SLOT_R_EAR = 2;
    public static final int SLOT_L_EAR = 4;
    public static final int SLOT_NECK = 8;
    public static final int SLOT_R_FINGER = 16;
    public static final int SLOT_L_FINGER = 32;
    public static final int SLOT_HEAD = 64;
    public static final int SLOT_R_HAND = 128;
    public static final int SLOT_L_HAND = 256;
    public static final int SLOT_GLOVES = 512;
    public static final int SLOT_CHEST = 1024;
    public static final int SLOT_LEGS = 2048;
    public static final int SLOT_FEET = 4096;
    public static final int SLOT_BACK = 8192;
    public static final int SLOT_LR_HAND = 16384;
    public static final int SLOT_FULL_ARMOR = 32768;
    public static final int SLOT_HAIR = 65536;
    public static final int MATERIAL_STEEL = 0;
    public static final int MATERIAL_FINE_STEEL = 1;
    public static final int MATERIAL_BLOOD_STEEL = 2;
    public static final int MATERIAL_BRONZE = 3;
    public static final int MATERIAL_SILVER = 4;
    public static final int MATERIAL_GOLD = 5;
    public static final int MATERIAL_MITHRIL = 6;
    public static final int MATERIAL_ORIHARUKON = 7;
    public static final int MATERIAL_PAPER = 8;
    public static final int MATERIAL_WOOD = 9;
    public static final int MATERIAL_CLOTH = 10;
    public static final int MATERIAL_LEATHER = 11;
    public static final int MATERIAL_BONE = 12;
    public static final int MATERIAL_HORN = 13;
    public static final int MATERIAL_DAMASCUS = 14;
    public static final int MATERIAL_ADAMANTAITE = 15;
    public static final int MATERIAL_CHRYSOLITE = 16;
    public static final int MATERIAL_CRYSTAL = 17;
    public static final int MATERIAL_LIQUID = 18;
    public static final int MATERIAL_SCALE_OF_DRAGON = 19;
    public static final int MATERIAL_DYESTUFF = 20;
    public static final int MATERIAL_COBWEB = 21;
    public static final int MATERIAL_SEED = 21;
    public static final int CRYSTAL_NONE = 0;
    public static final int CRYSTAL_D = 1;
    public static final int CRYSTAL_C = 2;
    public static final int CRYSTAL_B = 3;
    public static final int CRYSTAL_A = 4;
    public static final int CRYSTAL_S = 5;
    private static final Func[] _emptyFunctionSet = new Func[0];
    private static final L2Effect[] _emptyEffectSet = new L2Effect[0];
    private final int _itemId;
    private final String _name;
    private final int _type1;
    private final int _type2;
    private final int _weight;
    private final boolean _crystallizable;
    private final boolean _stackable;
    private final int _materialType;
    private final int _crystalType;
    private final int _durability;
    private final int _bodyPart;
    private final int _referencePrice;
    private final int _crystalCount;
    private final boolean _sellable;
    public final Enum type;
    protected FuncTemplate[] _funcTemplates;
    protected EffectTemplate[] _effectTemplates;

    protected L2Item(Enum type, StatsSet set2) {
        this.type = type;
        this._itemId = set2.getInteger("item_id");
        this._name = set2.getString("name");
        this._type1 = set2.getInteger("type1");
        this._type2 = set2.getInteger("type2");
        this._weight = set2.getInteger("weight");
        this._crystallizable = set2.getBool("crystallizable");
        this._stackable = set2.getBool("stackable", false);
        this._materialType = set2.getInteger("material");
        this._crystalType = set2.getInteger("crystal_type", 0);
        this._durability = set2.getInteger("durability");
        this._bodyPart = set2.getInteger("bodypart");
        this._referencePrice = set2.getInteger("price");
        this._crystalCount = set2.getInteger("crystal_count", 0);
        this._sellable = set2.getBool("sellable", true);
    }

    public Enum getItemType() {
        return this.type;
    }

    public final int getDurability() {
        return this._durability;
    }

    public final int getItemId() {
        return this._itemId;
    }

    public abstract int getItemMask();

    public final int getMaterialType() {
        return this._materialType;
    }

    public final int getType2() {
        return this._type2;
    }

    public final int getWeight() {
        return this._weight;
    }

    public final boolean isCrystallizable() {
        return this._crystallizable;
    }

    public final int getCrystalType() {
        return this._crystalType;
    }

    public final int getItemGrade() {
        return this.getCrystalType();
    }

    public final int getCrystalCount() {
        return this._crystalCount;
    }

    public final String getName() {
        return this._name;
    }

    public final int getBodyPart() {
        return this._bodyPart;
    }

    public final int getType1() {
        return this._type1;
    }

    public final boolean isStackable() {
        return this._stackable;
    }

    public final int getReferencePrice() {
        return this._referencePrice;
    }

    public final boolean isSellable() {
        return this._sellable;
    }

    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        if (this._funcTemplates == null) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>();
        for (FuncTemplate t : this._funcTemplates) {
            Env env = new Env();
            env._player = player;
            env._target = player;
            env._item = instance;
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.size() == 0) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public L2Effect[] getEffects(L2ItemInstance instance, L2Character player) {
        if (this._effectTemplates == null) {
            return _emptyEffectSet;
        }
        ArrayList<L2Effect> effects = new ArrayList<L2Effect>();
        for (EffectTemplate et : this._effectTemplates) {
            Env env = new Env();
            env._player = player;
            env._target = player;
            env._item = instance;
            L2Effect e = et.getEffect(env);
            if (e == null) continue;
            effects.add(e);
        }
        if (effects.size() == 0) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new FuncTemplate[]{f};
        } else {
            int len = this._funcTemplates.length;
            FuncTemplate[] tmp = new FuncTemplate[len + 1];
            System.arraycopy(this._funcTemplates, 0, tmp, 0, len);
            tmp[len] = f;
            this._funcTemplates = tmp;
        }
    }

    public void attach(EffectTemplate effect) {
        if (this._effectTemplates == null) {
            this._effectTemplates = new EffectTemplate[]{effect};
        } else {
            int len = this._effectTemplates.length;
            EffectTemplate[] tmp = new EffectTemplate[len + 1];
            System.arraycopy(this._effectTemplates, 0, tmp, 0, len);
            tmp[len] = effect;
            this._effectTemplates = tmp;
        }
    }

    public String toString() {
        return this._name;
    }
}

