/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.templates;

import java.util.ArrayList;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.FuncTemplate;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.gameserver.templates.StatsSet;

public final class L2Weapon
extends L2Item {
    private final int _soulShotCount;
    private final int _spiritShotCount;
    private final int _pDam;
    private final int _rndDam;
    private final int _critical;
    private final double _hitModifier;
    private final int _avoidModifier;
    private final int _shieldDef;
    private final double _shieldDefRate;
    private final int _atkSpeed;
    private final int _atkReuse;
    private final int _mpConsume;
    private final int _mDam;

    public L2Weapon(L2WeaponType type, StatsSet set2) {
        super(type, set2);
        this._soulShotCount = set2.getInteger("soulshots");
        this._spiritShotCount = set2.getInteger("spiritshots");
        this._pDam = set2.getInteger("p_dam");
        this._rndDam = set2.getInteger("rnd_dam");
        this._critical = set2.getInteger("critical");
        this._hitModifier = set2.getDouble("hit_modify");
        this._avoidModifier = set2.getInteger("avoid_modify");
        this._shieldDef = set2.getInteger("shield_def");
        this._shieldDefRate = set2.getDouble("shield_def_rate");
        this._atkSpeed = set2.getInteger("atk_speed");
        this._atkReuse = set2.getInteger("atk_reuse", type == L2WeaponType.BOW ? 1500 : 0);
        this._mpConsume = set2.getInteger("mp_consume");
        this._mDam = set2.getInteger("m_dam");
    }

    public L2WeaponType getItemType() {
        return (L2WeaponType)this.type;
    }

    public int getItemMask() {
        return this.getItemType().mask();
    }

    public int getSoulShotCount() {
        return this._soulShotCount;
    }

    public int getSpiritShotCount() {
        return this._spiritShotCount;
    }

    public int getPDamage() {
        return this._pDam;
    }

    public int getRandomDamage() {
        return this._rndDam;
    }

    public int getAttackSpeed() {
        return this._atkSpeed;
    }

    public int getAttackReuseDelay() {
        return this._atkReuse;
    }

    public int getAvoidModifier() {
        return this._avoidModifier;
    }

    public int getCritical() {
        return this._critical;
    }

    public double getHitModifier() {
        return this._hitModifier;
    }

    public int getMDamage() {
        return this._mDam;
    }

    public int getMpConsume() {
        return this._mpConsume;
    }

    public int getShieldDef() {
        return this._shieldDef;
    }

    public double getShieldDefRate() {
        return this._shieldDefRate;
    }

    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        ArrayList<Func> funcs = new ArrayList<Func>();
        if (this._funcTemplates != null) {
            for (FuncTemplate t : this._funcTemplates) {
                Env env = new Env();
                env._player = player;
                env._item = instance;
                Func f = t.getFunc(env, instance);
                if (f == null) continue;
                funcs.add(f);
            }
        }
        return funcs.toArray(new Func[funcs.size()]);
    }
}

