/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.templates;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatsSet {
    private final HashMap<String, Object> _set = new HashMap();

    public final HashMap<String, Object> getSet() {
        return this._set;
    }

    public void add(StatsSet newSet) {
        HashMap<String, Object> newMap = newSet.getSet();
        for (String key : newMap.keySet()) {
            Object value = newMap.get(key);
            this._set.put(key, value);
        }
    }

    public boolean getBool(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Boolean value required, but not specified");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    public boolean getBool(String name, boolean deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    public int getInteger(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public int getInteger(String name, int deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public float getFloat(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return (float)Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public float getFloat(String name, float deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return (float)Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public double getDouble(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public double getDouble(String name, float deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public String getString(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("String value required, but not specified");
        }
        return String.valueOf(val);
    }

    public String getString(String name, String deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        return String.valueOf(val);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but not specified");
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + "required, but found: " + val);
        }
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass, T deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + "required, but found: " + val);
        }
    }

    public void set(String name, String value) {
        this._set.put(name, value);
    }

    public void set(String name, boolean value) {
        this._set.put(name, value);
    }

    public void set(String name, int value) {
        this._set.put(name, value);
    }

    public void set(String name, double value) {
        this._set.put(name, value);
    }

    public void set(String name, Enum value) {
        this._set.put(name, value);
    }
}

