/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver;

import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.sf.l2j.gameserver.Connection;

public class LoginController {
    private static LoginController _instance;
    private Map<String, Integer> _logins = new HashMap<String, Integer>();
    private HashMap<String, Socket> _accountsInLoginServer;
    private HashMap<String, Connection> _accountsInGameServer = new HashMap();
    private int _maxAllowedOnlinePlayers;
    private HashMap _activeConnections;

    private LoginController() {
        this._accountsInLoginServer = new HashMap();
        this._activeConnections = new HashMap();
    }

    public static LoginController getInstance() {
        if (_instance == null) {
            _instance = new LoginController();
        }
        return _instance;
    }

    public int assignSessionKeyToLogin(String account, Socket _csocket) {
        int key = -1;
        key = (int)System.currentTimeMillis() & 0xFFFFFF;
        this._logins.put(account, new Integer(key));
        this._accountsInLoginServer.put(account, _csocket);
        return key;
    }

    public void addGameServerLogin(String account, Connection connection) {
        this._accountsInGameServer.put(account, connection);
    }

    public void removeGameServerLogin(String account) {
        if (account != null) {
            this._logins.remove(account);
            this._accountsInGameServer.remove(account);
        }
    }

    public void removeLoginServerLogin(String account) {
        if (account != null) {
            this._accountsInLoginServer.remove(account);
        }
    }

    public boolean isAccountInLoginServer(String account) {
        return this._accountsInLoginServer.containsKey(account);
    }

    public boolean isAccountInGameServer(String account) {
        return this._accountsInGameServer.containsKey(account);
    }

    public int getKeyForAccount(String account) {
        int key = 0;
        Integer result = this._logins.get(account);
        if (result != null) {
            key = result;
        }
        return key;
    }

    public int getOnlinePlayerCount() {
        return this._accountsInGameServer.size();
    }

    public int getMaxAllowedOnlinePlayers() {
        return this._maxAllowedOnlinePlayers;
    }

    public void setMaxAllowedOnlinePlayers(int maxAllowedOnlinePlayers) {
        this._maxAllowedOnlinePlayers = maxAllowedOnlinePlayers;
    }

    public boolean loginPossible(int access) {
        return this._accountsInGameServer.size() < this._maxAllowedOnlinePlayers || access >= 50;
    }

    public Connection getClientConnection(String loginName) {
        return this._accountsInGameServer.get(loginName);
    }

    public Socket getLoginServerConnection(String loginName) {
        return this._accountsInLoginServer.get(loginName);
    }
}

