/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver.serverpackets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ServerBasePacket {
    ByteArrayOutputStream _bao = new ByteArrayOutputStream();

    protected ServerBasePacket() {
    }

    protected void writeD(int value) {
        this._bao.write(value & 0xFF);
        this._bao.write(value >> 8 & 0xFF);
        this._bao.write(value >> 16 & 0xFF);
        this._bao.write(value >> 24 & 0xFF);
    }

    protected void writeH(int value) {
        this._bao.write(value & 0xFF);
        this._bao.write(value >> 8 & 0xFF);
    }

    protected void writeC(int value) {
        this._bao.write(value & 0xFF);
    }

    protected void writeF(double org) {
        long value = Double.doubleToRawLongBits(org);
        this._bao.write((int)(value & 0xFFL));
        this._bao.write((int)(value >> 8 & 0xFFL));
        this._bao.write((int)(value >> 16 & 0xFFL));
        this._bao.write((int)(value >> 24 & 0xFFL));
        this._bao.write((int)(value >> 32 & 0xFFL));
        this._bao.write((int)(value >> 40 & 0xFFL));
        this._bao.write((int)(value >> 48 & 0xFFL));
        this._bao.write((int)(value >> 56 & 0xFFL));
    }

    protected void writeS(String text) {
        try {
            if (text != null) {
                this._bao.write(text.getBytes("UTF-16LE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._bao.write(0);
        this._bao.write(0);
    }

    public int getLength() {
        return this._bao.size() + 2;
    }

    public byte[] getBytes() {
        this.writeD(0);
        int padding = this._bao.size() % 8;
        if (padding != 0) {
            for (int i = padding; i < 8; ++i) {
                this.writeC(0);
            }
        }
        return this._bao.toByteArray();
    }

    public abstract byte[] getContent() throws IOException;
}

