/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver.serverpackets;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.sf.l2j.loginserver.serverpackets.ServerBasePacket;

public class ServerList
extends ServerBasePacket {
    private ArrayList<ServerData> _servers = new ArrayList();

    public void addServer(String ip, int port, boolean pvp, boolean testServer, int currentPlayer, int maxPlayer) {
        this._servers.add(new ServerData(ip, port, pvp, testServer, currentPlayer, maxPlayer));
    }

    public byte[] getContent() {
        this.writeC(4);
        this.writeC(this._servers.size());
        this.writeC(0);
        for (int i = 0; i < this._servers.size(); ++i) {
            ServerData server = this._servers.get(i);
            this.writeC(i + 1);
            try {
                InetAddress i4 = InetAddress.getByName(server.ip);
                byte[] raw = i4.getAddress();
                this.writeC(raw[0] & 0xFF);
                this.writeC(raw[1] & 0xFF);
                this.writeC(raw[2] & 0xFF);
                this.writeC(raw[3] & 0xFF);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                this.writeC(127);
                this.writeC(0);
                this.writeC(0);
                this.writeC(1);
            }
            this.writeD(server.port);
            this.writeC(15);
            if (server.pvp) {
                this.writeC(1);
            } else {
                this.writeC(0);
            }
            this.writeH(server.currentPlayers);
            this.writeH(server.maxPlayers);
            this.writeC(1);
            if (server.testServer) {
                this.writeD(4);
            } else {
                this.writeD(0);
            }
            this.writeC(1);
        }
        return this.getBytes();
    }

    class ServerData {
        String ip;
        int port;
        boolean pvp;
        int currentPlayers;
        int maxPlayers;
        boolean testServer;

        ServerData(String ip, int port, boolean pvp, boolean testServer, int currentPlayers, int maxPlayers) {
            this.ip = ip;
            this.port = port;
            this.pvp = pvp;
            this.testServer = testServer;
            this.currentPlayers = currentPlayers;
            this.maxPlayers = maxPlayers;
        }
    }
}

