/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.util.L2ObjectMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class L2ObjectHashMap<T extends L2Object>
implements Iterable<T>,
L2ObjectMap<T> {
    private final boolean TRACE = false;
    private final boolean DEBUG = false;
    private static final int[] primes = new int[]{5, 7, 11, 17, 23, 29, 37, 47, 59, 71, 89, 107, 131, 163, 197, 239, 293, 353, 431, 521, 631, 761, 919, 1103, 1327, 1597, 1931, 2333, 2801, 3371, 4049, 4861, 5839, 7013, 8419, 10103, 12143, 14591, 17519, 21023, 25229, 30293, 36353, 43627, 52361, 62851, 75431, 90523, 108631, 130363, 156437, 187751, 225307, 270371, 324449, 389357, 467237, 560689, 672827, 807403, 968897, 1162687, 1395263, 1674319, 2009191, 2411033, 2893249, 3471899, 4166287, 4999559, 5999471, 7199369};
    private T[] table;
    private int[] keys;
    private int count;

    private static int getPrime(int min) {
        for (int i = 0; i < primes.length; ++i) {
            if (primes[i] < min) continue;
            return primes[i];
        }
        throw new OutOfMemoryError();
    }

    public L2ObjectHashMap() {
        int size = primes[0];
        this.table = new L2Object[size];
        this.keys = new int[size];
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized void clear() {
        int size = primes[0];
        this.table = new L2Object[size];
        this.keys = new int[size];
        this.count = 0;
    }

    private void check() {
    }

    @Override
    public synchronized void put(T obj) {
        if (this.count >= this.table.length / 2) {
            this.expand();
        }
        int hashcode = ((L2Object)obj).getObjectId();
        if (Config.ASSERT) assert (hashcode > 0);
        int seed = hashcode;
        int incr = 1 + ((seed >> 5) + 1) % (this.table.length - 1);
        int ntry = 0;
        int slot = -1;
        do {
            int pos;
            if (this.table[pos = seed % this.table.length & Integer.MAX_VALUE] == null) {
                if (slot < 0) {
                    slot = pos;
                }
                if (this.keys[pos] >= 0) {
                    this.keys[slot] = hashcode;
                    this.table[slot] = obj;
                    ++this.count;
                    return;
                }
            } else {
                if (this.table[pos] == obj) {
                    return;
                }
                if (Config.ASSERT) assert (((L2Object)obj).getObjectId() != ((L2Object)this.table[pos]).getObjectId());
                if (slot >= 0 && this.keys[pos] > 0) {
                    int n = slot;
                    this.keys[n] = this.keys[n] | hashcode;
                    this.table[slot] = obj;
                    ++this.count;
                    return;
                }
            }
            int n = pos;
            this.keys[n] = this.keys[n] | Integer.MIN_VALUE;
            seed += incr;
        } while (++ntry < this.table.length);
        throw new IllegalStateException();
    }

    @Override
    public synchronized void remove(T obj) {
        int hashcode = ((L2Object)obj).getObjectId();
        if (Config.ASSERT) assert (hashcode > 0);
        int seed = hashcode;
        int incr = 1 + ((seed >> 5) + 1) % (this.table.length - 1);
        int ntry = 0;
        do {
            int pos;
            if (this.table[pos = seed % this.table.length & Integer.MAX_VALUE] == obj) {
                int n = pos;
                this.keys[n] = this.keys[n] & Integer.MIN_VALUE;
                this.table[pos] = null;
                --this.count;
                return;
            }
            if (this.table[pos] == null && this.keys[pos] >= 0) {
                return;
            }
            seed += incr;
        } while (++ntry < this.table.length);
        throw new IllegalStateException();
    }

    @Override
    public T get(int id) {
        int size = this.table.length;
        if (id <= 0) {
            return null;
        }
        if (size <= 11) {
            for (int i = 0; i < size; ++i) {
                if ((this.keys[i] & Integer.MAX_VALUE) != id) continue;
                return this.table[i];
            }
            return null;
        }
        int seed = id;
        int incr = 1 + ((seed >> 5) + 1) % (size - 1);
        int ntry = 0;
        do {
            int pos;
            if ((this.keys[pos = seed % size & Integer.MAX_VALUE] & Integer.MAX_VALUE) == id) {
                return this.table[pos];
            }
            if (this.table[pos] == null && this.keys[pos] >= 0) {
                return null;
            }
            seed += incr;
        } while (++ntry < size);
        return null;
    }

    @Override
    public boolean contains(T obj) {
        return this.get(((L2Object)obj).getObjectId()) != null;
    }

    private void expand() {
        int newSize = L2ObjectHashMap.getPrime(this.table.length + 1);
        L2Object[] newTable = new L2Object[newSize];
        int[] newKeys = new int[newSize];
        block0: for (int i = 0; i < this.table.length; ++i) {
            T obj = this.table[i];
            if (obj == null) continue;
            int hashcode = this.keys[i] & Integer.MAX_VALUE;
            if (Config.ASSERT) assert (hashcode == ((L2Object)obj).getObjectId());
            int seed = hashcode;
            int incr = 1 + ((seed >> 5) + 1) % (newSize - 1);
            int ntry = 0;
            do {
                int pos;
                if (newTable[pos = seed % newSize & Integer.MAX_VALUE] == null) {
                    if (Config.ASSERT) assert (newKeys[pos] == 0 && hashcode != 0);
                    newKeys[pos] = hashcode;
                    newTable[pos] = obj;
                    continue block0;
                }
                int n = pos;
                newKeys[n] = newKeys[n] | Integer.MIN_VALUE;
                seed += incr;
            } while (++ntry < newSize);
            throw new IllegalStateException();
        }
        this.table = newTable;
        this.keys = newKeys;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr(this, this.table);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Itr
    implements Iterator<T> {
        private final T[] array;
        private int nextIdx;
        private T nextObj;
        private T lastRet;
        final /* synthetic */ L2ObjectHashMap this$0;

        Itr(T[] array) {
            this.this$0 = var1_1;
            this.array = array;
            while (this.nextIdx < array.length) {
                this.nextObj = array[this.nextIdx];
                if (this.nextObj != null) {
                    return;
                }
                ++this.nextIdx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextObj != null;
        }

        @Override
        public T next() {
            if (this.nextObj == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.nextObj;
            ++this.nextIdx;
            while (this.nextIdx < this.array.length) {
                this.nextObj = this.array[this.nextIdx];
                if (this.nextObj != null) break;
                ++this.nextIdx;
            }
            if (this.nextIdx >= this.array.length) {
                this.nextObj = null;
            }
            return this.lastRet;
        }

        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.lastRet);
        }
    }
}

