/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPerTaskAsynchronousRunner;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class ThreadPoolAsynchronousRunner
implements AsynchronousRunner {
    static final MLogger logger = MLog.getLogger(ThreadPoolAsynchronousRunner.class);
    static final int POLL_FOR_STOP_INTERVAL = 5000;
    static final int DFLT_DEADLOCK_DETECTOR_INTERVAL = 10000;
    static final int DFLT_INTERRUPT_DELAY_AFTER_APPARENT_DEADLOCK = 60000;
    static final int DFLT_MAX_INDIVIDUAL_TASK_TIME = 0;
    static final int DFLT_MAX_EMERGENCY_THREADS = 10;
    int deadlock_detector_interval;
    int interrupt_delay_after_apparent_deadlock;
    int max_individual_task_time;
    int num_threads;
    boolean daemon;
    HashSet managed;
    HashSet available;
    LinkedList pendingTasks;
    Timer myTimer;
    boolean should_cancel_timer;
    TimerTask deadlockDetector = new DeadlockDetector();
    TimerTask replacedThreadInterruptor = new ReplacedThreadInterruptor();
    Map stoppedThreadsToStopDates = new HashMap();

    private ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer, boolean should_cancel_timer) {
        this.num_threads = num_threads;
        this.daemon = daemon;
        this.max_individual_task_time = max_individual_task_time;
        this.deadlock_detector_interval = deadlock_detector_interval;
        this.interrupt_delay_after_apparent_deadlock = interrupt_delay_after_apparent_deadlock;
        this.myTimer = myTimer;
        this.should_cancel_timer = should_cancel_timer;
        this.recreateThreadsAndTasks();
        myTimer.schedule(this.deadlockDetector, deadlock_detector_interval, (long)deadlock_detector_interval);
        int replacedThreadProcessDelay = interrupt_delay_after_apparent_deadlock / 4;
        myTimer.schedule(this.replacedThreadInterruptor, replacedThreadProcessDelay, (long)replacedThreadProcessDelay);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, myTimer, false);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, new Timer(true), true);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, Timer sharedTimer) {
        this(num_threads, daemon, 0, 10000, 60000, sharedTimer, false);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon) {
        this(num_threads, daemon, 0, 10000, 60000, new Timer(true), true);
    }

    public synchronized void postRunnable(Runnable r) {
        try {
            this.pendingTasks.add(r);
            this.notifyAll();
        }
        catch (NullPointerException e) {
            throw new ResourceClosedException("Attempted to use a ThreadPoolAsynchronousRunner in a closed or broken state.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean skip_remaining_tasks) {
        ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = this;
        synchronized (threadPoolAsynchronousRunner) {
            if (this.managed == null) {
                return;
            }
            this.deadlockDetector.cancel();
            this.replacedThreadInterruptor.cancel();
            if (this.should_cancel_timer) {
                this.myTimer.cancel();
            }
            this.myTimer = null;
            for (PoolThread stopMe : this.managed) {
                stopMe.gentleStop();
                if (!skip_remaining_tasks) continue;
                stopMe.interrupt();
            }
            this.managed = null;
            if (!skip_remaining_tasks) {
                Iterator ii = this.pendingTasks.iterator();
                while (ii.hasNext()) {
                    Runnable r = (Runnable)ii.next();
                    new Thread(r).start();
                    ii.remove();
                }
            }
            this.available = null;
            this.pendingTasks = null;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized String getStatus() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.toString());
        sb.append(' ');
        this.appendStatusString(sb);
        return sb.toString();
    }

    private void appendStatusString(StringBuffer sb) {
        if (this.managed == null) {
            sb.append("[closed]");
        } else {
            HashSet active = (HashSet)this.managed.clone();
            active.removeAll(this.available);
            sb.append("[num_managed_threads: ");
            sb.append(this.managed.size());
            sb.append(", num_active: ");
            sb.append(active.size());
            sb.append("; activeTasks: ");
            boolean first = true;
            Iterator ii = active.iterator();
            while (ii.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                PoolThread pt = (PoolThread)ii.next();
                sb.append(pt.getCurrentTask());
                sb.append(" (");
                sb.append(pt.getName());
                sb.append(')');
            }
            sb.append("; pendingTasks: ");
            int len = this.pendingTasks.size();
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.pendingTasks.get(i));
            }
            sb.append(']');
        }
    }

    private void recreateThreadsAndTasks() {
        if (this.managed != null) {
            Date aboutNow = new Date();
            for (PoolThread pt : this.managed) {
                pt.gentleStop();
                this.stoppedThreadsToStopDates.put(pt, aboutNow);
            }
        }
        this.managed = new HashSet();
        this.available = new HashSet();
        this.pendingTasks = new LinkedList();
        for (int i = 0; i < this.num_threads; ++i) {
            PoolThread t = new PoolThread(i, this.daemon);
            this.managed.add(t);
            this.available.add(t);
            t.start();
        }
    }

    private void processReplacedThreads() {
        long about_now = System.currentTimeMillis();
        Iterator ii = this.stoppedThreadsToStopDates.keySet().iterator();
        while (ii.hasNext()) {
            PoolThread pt = (PoolThread)ii.next();
            if (!pt.isAlive()) {
                ii.remove();
                continue;
            }
            Date d = (Date)this.stoppedThreadsToStopDates.get(pt);
            if (about_now - d.getTime() <= (long)this.interrupt_delay_after_apparent_deadlock) continue;
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Task " + pt.getCurrentTask() + " (in deadlocked PoolThread) failed to complete in maximum time " + this.interrupt_delay_after_apparent_deadlock + "ms. Trying interrupt().");
            }
            pt.interrupt();
            ii.remove();
        }
    }

    private void shuttingDown(PoolThread pt) {
        if (this.managed != null && this.managed.contains(pt)) {
            this.managed.remove(pt);
            this.available.remove(pt);
            PoolThread replacement = new PoolThread(pt.getIndex(), this.daemon);
            this.managed.add(replacement);
            this.available.add(replacement);
            replacement.start();
        }
    }

    private void runInEmergencyThread(Runnable r) {
        final Thread t = new Thread(r);
        t.start();
        if (this.max_individual_task_time > 0) {
            TimerTask maxIndividualTaskTimeEnforcer = new TimerTask(){

                public void run() {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Task " + t + " (in one-off task Thread created after deadlock) failed to complete in maximum time " + ThreadPoolAsynchronousRunner.this.max_individual_task_time + " ms. Trying interrupt().");
                    }
                    t.interrupt();
                }
            };
            this.myTimer.schedule(maxIndividualTaskTimeEnforcer, this.max_individual_task_time);
        }
    }

    class ReplacedThreadInterruptor
    extends TimerTask {
        ReplacedThreadInterruptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                ThreadPoolAsynchronousRunner.this.processReplacedThreads();
            }
        }
    }

    class DeadlockDetector
    extends TimerTask {
        LinkedList last = null;
        LinkedList current = null;

        DeadlockDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean run_stray_tasks = false;
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                if (ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                    this.last = null;
                    return;
                }
                this.current = (LinkedList)ThreadPoolAsynchronousRunner.this.pendingTasks.clone();
                if (this.current.equals(this.last)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.warning(this + " -- APPARENT DEADLOCK!!! Creating emergency threads for unassigned pending tasks!");
                        StringBuffer sb = new StringBuffer(512);
                        sb.append(this);
                        sb.append(" -- APPARENT DEADLOCK!!! Complete Status: ");
                        ThreadPoolAsynchronousRunner.this.appendStatusString(sb);
                        logger.warning(sb.toString());
                    }
                    ThreadPoolAsynchronousRunner.this.recreateThreadsAndTasks();
                    run_stray_tasks = true;
                }
            }
            if (run_stray_tasks) {
                ThreadPerTaskAsynchronousRunner ar = new ThreadPerTaskAsynchronousRunner(10, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
                Iterator ii = this.current.iterator();
                while (ii.hasNext()) {
                    ar.postRunnable((Runnable)ii.next());
                }
                ar.close(false);
                this.last = null;
            } else {
                this.last = this.current;
            }
            this.current = null;
        }
    }

    class PoolThread
    extends Thread {
        Runnable currentTask;
        boolean should_stop;
        int index;
        TimerTask maxIndividualTaskTimeEnforcer;

        PoolThread(int index, boolean daemon) {
            this.setName(this.getClass().getName() + "-#" + index);
            this.setDaemon(daemon);
            this.index = index;
            if (ThreadPoolAsynchronousRunner.this.max_individual_task_time > 0) {
                this.maxIndividualTaskTimeEnforcer = new TimerTask(){

                    public void run() {
                        PoolThread.this.interrupt();
                    }
                };
            }
        }

        public int getIndex() {
            return this.index;
        }

        void gentleStop() {
            this.should_stop = true;
        }

        Runnable getCurrentTask() {
            return this.currentTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Runnable myTask;
                    ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                    synchronized (threadPoolAsynchronousRunner) {
                        while (!this.should_stop && ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                            ThreadPoolAsynchronousRunner.this.wait(5000L);
                        }
                        if (this.should_stop) {
                            break;
                        }
                        if (!ThreadPoolAsynchronousRunner.this.available.remove(this)) {
                            throw new InternalError("An unavailable PoolThread tried to check itself out!!!");
                        }
                        this.currentTask = myTask = (Runnable)ThreadPoolAsynchronousRunner.this.pendingTasks.remove(0);
                    }
                    try {
                        if (this.maxIndividualTaskTimeEnforcer != null) {
                            ThreadPoolAsynchronousRunner.this.myTimer.schedule(this.maxIndividualTaskTimeEnforcer, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
                        }
                        myTask.run();
                    }
                    catch (RuntimeException e) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, this + " -- caught unexpected Exception while executing posted task.", e);
                    }
                    finally {
                        if (this.maxIndividualTaskTimeEnforcer != null) {
                            this.maxIndividualTaskTimeEnforcer.cancel();
                        }
                        threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                        synchronized (threadPoolAsynchronousRunner) {
                            if (this.should_stop) {
                                break;
                            }
                            if (ThreadPoolAsynchronousRunner.this.available != null && !ThreadPoolAsynchronousRunner.this.available.add(this)) {
                                throw new InternalError("An apparently available PoolThread tried to check itself in!!!");
                            }
                            this.currentTask = null;
                        }
                    }
                }
                catch (InterruptedException exc) {
                    if (!logger.isLoggable(MLevel.FINE)) break;
                    logger.fine(this + " interrupted. Shutting down.");
                    break;
                }
            }
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                ThreadPoolAsynchronousRunner.this.shuttingDown(this);
            }
        }
    }
}

