/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPoolManager {
    private static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPoolManager.class);
    private static final boolean POOL_EVENT_SUPPORT = false;
    private static final CoalesceChecker COALESCE_CHECKER = new CoalesceChecker(){

        public boolean checkCoalesce(Object a, Object b) {
            C3P0PooledConnectionPoolManager aa = (C3P0PooledConnectionPoolManager)a;
            C3P0PooledConnectionPoolManager bb = (C3P0PooledConnectionPoolManager)b;
            return aa.poolOwnerIdentityToken.equals(bb.poolOwnerIdentityToken) && (aa.preferredTestQuery == null ? bb.preferredTestQuery == null : aa.preferredTestQuery.equals(bb.preferredTestQuery)) && (aa.automaticTestTable == null ? bb.automaticTestTable == null : aa.automaticTestTable.equals(bb.automaticTestTable)) && aa.sourceCpdsIdentityToken.equals(bb.sourceCpdsIdentityToken) && aa.num_task_threads == bb.num_task_threads && aa.maxStatements == bb.maxStatements && aa.maxStatementsPerConnection == bb.maxStatementsPerConnection && aa.minPoolSize == bb.minPoolSize && aa.idleConnectionTestPeriod == bb.idleConnectionTestPeriod && aa.maxIdleTime == bb.maxIdleTime && aa.checkoutTimeout == bb.checkoutTimeout && aa.acquireIncrement == bb.acquireIncrement && aa.acquireRetryAttempts == bb.acquireRetryAttempts && aa.acquireRetryDelay == bb.acquireRetryDelay && aa.breakAfterAcquireFailure == bb.breakAfterAcquireFailure && aa.testConnectionOnCheckout == bb.testConnectionOnCheckout && aa.testConnectionOnCheckin == bb.testConnectionOnCheckin && aa.autoCommitOnClose == bb.autoCommitOnClose && aa.forceIgnoreUnresolvedTransactions == bb.forceIgnoreUnresolvedTransactions && aa.defaultAuth.equals(bb.defaultAuth) && aa.connectionTester.getClass().equals(bb.connectionTester.getClass());
        }

        public int coalesceHash(Object a) {
            C3P0PooledConnectionPoolManager aa = (C3P0PooledConnectionPoolManager)a;
            int out = aa.poolOwnerIdentityToken.hashCode() ^ (aa.preferredTestQuery == null ? 0 : aa.preferredTestQuery.hashCode()) ^ (aa.automaticTestTable == null ? 0 : aa.automaticTestTable.hashCode()) ^ aa.sourceCpdsIdentityToken.hashCode() ^ aa.num_task_threads ^ aa.maxStatements ^ aa.maxStatementsPerConnection ^ aa.minPoolSize ^ aa.idleConnectionTestPeriod ^ aa.maxIdleTime ^ aa.checkoutTimeout ^ aa.acquireIncrement ^ aa.acquireRetryAttempts ^ aa.acquireRetryDelay ^ (aa.testConnectionOnCheckout ? 1 : 0) ^ (aa.testConnectionOnCheckin ? 2 : 0) ^ (aa.autoCommitOnClose ? 4 : 0) ^ (aa.forceIgnoreUnresolvedTransactions ? 8 : 0) ^ (aa.breakAfterAcquireFailure ? 16 : 0) ^ aa.defaultAuth.hashCode() ^ aa.connectionTester.getClass().hashCode();
            return out;
        }
    };
    static final Coalescer COALESCER = CoalescerFactory.createCoalescer(COALESCE_CHECKER, true, false);
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    Set activeClients = new HashSet();
    ThreadPoolAsynchronousRunner taskRunner;
    Timer timer;
    ResourcePoolFactory rpfact;
    GooGooStatementCache scache;
    Map authsToPools;
    boolean is_first_pool = true;
    String realTestQuery;
    String poolOwnerIdentityToken = null;
    final ConnectionPoolDataSource cpds;
    final String sourceCpdsIdentityToken;
    int num_task_threads = 3;
    int maxStatements = PoolConfig.defaultMaxStatements();
    int maxStatementsPerConnection = PoolConfig.defaultMaxStatementsPerConnection();
    int minPoolSize = PoolConfig.defaultMinPoolSize();
    int maxPoolSize = PoolConfig.defaultMaxPoolSize();
    int idleConnectionTestPeriod = PoolConfig.defaultIdleConnectionTestPeriod();
    int maxIdleTime = PoolConfig.defaultMaxIdleTime();
    int checkoutTimeout = PoolConfig.defaultCheckoutTimeout();
    int acquireIncrement = PoolConfig.defaultAcquireIncrement();
    int acquireRetryAttempts = PoolConfig.defaultAcquireRetryAttempts();
    int acquireRetryDelay = PoolConfig.defaultAcquireRetryDelay();
    boolean breakAfterAcquireFailure = PoolConfig.defaultBreakAfterAcquireFailure();
    boolean testConnectionOnCheckout = PoolConfig.defaultTestConnectionOnCheckout();
    boolean testConnectionOnCheckin = PoolConfig.defaultTestConnectionOnCheckin();
    boolean autoCommitOnClose = PoolConfig.defaultAutoCommitOnClose();
    boolean forceIgnoreUnresolvedTransactions = PoolConfig.defaultForceIgnoreUnresolvedTransactions();
    String preferredTestQuery = PoolConfig.defaultPreferredTestQuery();
    String automaticTestTable = PoolConfig.defaultAutomaticTestTable();
    DbAuth defaultAuth = C3P0ImplUtils.NULL_AUTH;
    ConnectionTester connectionTester = C3P0ImplUtils.defaultConnectionTester();

    private synchronized void poolsInit() {
        this.timer = new Timer(true);
        this.taskRunner = new ThreadPoolAsynchronousRunner(this.num_task_threads, true, this.timer);
        this.rpfact = BasicResourcePoolFactory.createNoEventSupportInstance(this.taskRunner, this.timer);
        this.scache = this.maxStatements > 0 && this.maxStatementsPerConnection > 0 ? new DoubleMaxStatementCache(this.taskRunner, this.maxStatements, this.maxStatementsPerConnection) : (this.maxStatementsPerConnection > 0 ? new PerConnectionMaxOnlyStatementCache(this.taskRunner, this.maxStatementsPerConnection) : (this.maxStatements > 0 ? new GlobalMaxOnlyStatementCache(this.taskRunner, this.maxStatements) : null));
        this.authsToPools = new HashMap();
    }

    private synchronized void poolsDestroy() {
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)ii.next()).close();
            }
            catch (Exception e) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to clean up a pool!", e);
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException e) {
            logger.log(MLevel.WARNING, "An Exception occurred while trying to clean up a Statement cache!", e);
        }
        this.scache = null;
        this.taskRunner = null;
        this.timer = null;
        this.rpfact = null;
        this.authsToPools = null;
    }

    public static synchronized C3P0PooledConnectionPoolManager find(String poolOwnerIdentityToken, ConnectionPoolDataSource cpds, String sourceCpdsIdentityToken, int num_task_threads) throws SQLException {
        C3P0PooledConnectionPoolManager nascent = new C3P0PooledConnectionPoolManager(poolOwnerIdentityToken, cpds, sourceCpdsIdentityToken, num_task_threads);
        C3P0PooledConnectionPoolManager out = (C3P0PooledConnectionPoolManager)COALESCER.coalesce(nascent);
        if (out == nascent) {
            out.poolsInit();
        }
        return out;
    }

    private C3P0PooledConnectionPoolManager(String poolOwnerIdentityToken, ConnectionPoolDataSource cpds, String sourceCpdsIdentityToken, int num_task_threads) throws SQLException {
        try {
            this.poolOwnerIdentityToken = poolOwnerIdentityToken;
            this.cpds = cpds;
            this.sourceCpdsIdentityToken = sourceCpdsIdentityToken;
            this.num_task_threads = num_task_threads;
            this.defaultAuth = C3P0ImplUtils.findAuth(cpds);
            BeanInfo bi = Introspector.getBeanInfo(cpds.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                int value;
                Object propVal;
                Class<?> propCl = pd.getPropertyType();
                String propName = pd.getName();
                Method readMethod = pd.getReadMethod();
                if (propCl == Integer.TYPE) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    value = (Integer)propVal;
                    if ("maxStatements".equals(propName)) {
                        this.maxStatements = value;
                        continue;
                    }
                    if ("maxStatementsPerConnection".equals(propName)) {
                        this.maxStatementsPerConnection = value;
                        continue;
                    }
                    if ("minPoolSize".equals(propName)) {
                        this.minPoolSize = value;
                        continue;
                    }
                    if ("maxPoolSize".equals(propName)) {
                        this.maxPoolSize = value;
                        continue;
                    }
                    if ("idleConnectionTestPeriod".equals(propName)) {
                        this.idleConnectionTestPeriod = value;
                        continue;
                    }
                    if ("maxIdleTime".equals(propName)) {
                        this.maxIdleTime = value;
                        continue;
                    }
                    if ("checkoutTimeout".equals(propName)) {
                        this.checkoutTimeout = value;
                        continue;
                    }
                    if ("acquireIncrement".equals(propName)) {
                        this.acquireIncrement = value;
                        continue;
                    }
                    if ("acquireRetryAttempts".equals(propName)) {
                        this.acquireRetryAttempts = value;
                        continue;
                    }
                    if (!"acquireRetryDelay".equals(propName)) continue;
                    this.acquireRetryDelay = value;
                    continue;
                }
                if (propCl == String.class) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    String value2 = (String)propVal;
                    if ("connectionTesterClassName".equals(propName)) {
                        this.connectionTester = (ConnectionTester)Class.forName(value2).newInstance();
                        continue;
                    }
                    if ("preferredTestQuery".equals(propName)) {
                        this.preferredTestQuery = value2;
                        continue;
                    }
                    if (!"automaticTestTable".equals(propName)) continue;
                    this.automaticTestTable = value2;
                    continue;
                }
                if (propCl != Boolean.TYPE) continue;
                propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                value = ((Boolean)propVal).booleanValue() ? 1 : 0;
                if ("testConnectionOnCheckout".equals(propName)) {
                    this.testConnectionOnCheckout = value;
                    continue;
                }
                if ("testConnectionOnCheckin".equals(propName)) {
                    this.testConnectionOnCheckin = value;
                    continue;
                }
                if ("autoCommitOnClose".equals(propName)) {
                    this.autoCommitOnClose = value;
                    continue;
                }
                if ("forceIgnoreUnresolvedTransactions".equals(propName)) {
                    this.forceIgnoreUnresolvedTransactions = value;
                    continue;
                }
                if (!"breakAfterAcquireFailure".equals(propName)) continue;
                this.breakAfterAcquireFailure = value;
            }
        }
        catch (Exception e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(String username, String password) throws SQLException {
        return this.getPool(new DbAuth(username, password));
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth auth) throws SQLException {
        C3P0PooledConnectionPool out = (C3P0PooledConnectionPool)this.authsToPools.get(auth);
        if (out == null) {
            out = this.createPooledConnectionPool(auth);
            this.authsToPools.put(auth, out);
        }
        return out;
    }

    public synchronized int getNumManagedAuths() {
        return this.authsToPools.size();
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized int getNumIdleConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumIdleConnections();
        }
        return out;
    }

    public synchronized int getNumBusyConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumBusyConnections();
        }
        return out;
    }

    public synchronized int getNumConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumConnections();
        }
        return out;
    }

    public synchronized int getNumUnclosedOrphanedConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumUnclosedOrphanedConnections();
        }
        return out;
    }

    public synchronized void softResetAllAuths() throws SQLException {
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            ((C3P0PooledConnectionPool)ii.next()).reset();
        }
    }

    public synchronized void close() {
        if (this.authsToPools != null) {
            this.poolsDestroy();
        }
    }

    protected synchronized void finalize() {
        this.close();
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth auth) throws SQLException {
        if (this.is_first_pool) {
            if (this.automaticTestTable != null) {
                this.realTestQuery = this.initializeAutomaticTestTable();
                if (this.preferredTestQuery != null && logger.isLoggable(MLevel.WARNING)) {
                    logger.logp(MLevel.WARNING, C3P0PooledConnectionPoolManager.class.getName(), "createPooledConnectionPool", "[c3p0] Both automaticTestTable and preferredTestQuery have been set! Using automaticTestTable, and ignoring preferredTestQuery. Real test query is ''{0}''.", this.realTestQuery);
                }
            } else {
                this.realTestQuery = this.preferredTestQuery;
            }
        }
        C3P0PooledConnectionPool out = new C3P0PooledConnectionPool(this.cpds, auth, this.minPoolSize, this.maxPoolSize, this.acquireIncrement, this.acquireRetryAttempts, this.acquireRetryDelay, this.breakAfterAcquireFailure, this.checkoutTimeout, this.idleConnectionTestPeriod, this.maxIdleTime, this.testConnectionOnCheckout, this.testConnectionOnCheckin, this.scache, this.connectionTester, this.realTestQuery, this.rpfact);
        this.is_first_pool = false;
        return out;
    }

    public synchronized void registerActiveClient(Object o) {
        this.activeClients.add(o);
        if (this.authsToPools == null) {
            this.poolsInit();
        }
    }

    public synchronized void unregisterActiveClient(Object o) {
        this.activeClients.remove(o);
        if (this.activeClients.size() == 0) {
            this.close();
        }
    }

    public synchronized void forceDestroy() {
        if (this.activeClients.size() > 0) {
            this.activeClients.clear();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initializeAutomaticTestTable() throws SQLException {
        String string;
        PooledConnection throwawayPooledConnection = this.cpds.getPooledConnection();
        Connection c = null;
        PreparedStatement testStmt = null;
        PreparedStatement createStmt = null;
        ResultSet mdrs = null;
        ResultSet rs = null;
        try {
            c = throwawayPooledConnection.getConnection();
            DatabaseMetaData dmd = c.getMetaData();
            String q = dmd.getIdentifierQuoteString();
            String quotedTableName = q + this.automaticTestTable + q;
            String out = "SELECT * FROM " + quotedTableName;
            mdrs = dmd.getTables(null, null, this.automaticTestTable, new String[]{"TABLE"});
            boolean exists = mdrs.next();
            if (exists) {
                testStmt = c.prepareStatement(out);
                rs = testStmt.executeQuery();
                boolean has_rows = rs.next();
                if (has_rows) {
                    throw new SQLException("automatic test table '" + this.automaticTestTable + "' contains rows, and it should not! Please set this " + "parameter to the name of a table c3p0 can create on its own, " + "that is not used elsewhere in the database!");
                }
            } else {
                createStmt = c.prepareStatement("CREATE TABLE " + quotedTableName + " ( a CHAR(1) )");
                createStmt.executeUpdate();
            }
            string = out;
        }
        catch (Throwable throwable) {
            ResultSetUtils.attemptClose(mdrs);
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(testStmt);
            StatementUtils.attemptClose(createStmt);
            ConnectionUtils.attemptClose(c);
            try {
                if (throwawayPooledConnection != null) {
                    throwawayPooledConnection.close();
                }
            }
            catch (Exception e) {
                logger.log(MLevel.WARNING, "A PooledConnection failed to close.", e);
            }
            throw throwable;
        }
        ResultSetUtils.attemptClose(mdrs);
        ResultSetUtils.attemptClose(rs);
        StatementUtils.attemptClose(testStmt);
        StatementUtils.attemptClose(createStmt);
        ConnectionUtils.attemptClose(c);
        try {
            if (throwawayPooledConnection != null) {
                throwawayPooledConnection.close();
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, "A PooledConnection failed to close.", e);
        }
        return string;
    }
}

