/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.lang.Coerce;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.ser.SerializableUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class JavaBeanObjectFactory
implements ObjectFactory {
    private static final MLogger logger = MLog.getLogger(JavaBeanObjectFactory.class);
    static final Object NULL_TOKEN = new Object();

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        if (refObj instanceof Reference) {
            Reference ref = (Reference)refObj;
            HashMap<String, RefAddr> refAddrsMap = new HashMap<String, RefAddr>();
            Enumeration<RefAddr> e = ref.getAll();
            while (e.hasMoreElements()) {
                RefAddr addr = e.nextElement();
                refAddrsMap.put(addr.getType(), addr);
            }
            Class<?> beanClass = Class.forName(ref.getClassName());
            Set refProps = null;
            BinaryRefAddr refPropsRefAddr = (BinaryRefAddr)refAddrsMap.remove("com.mchange.v2.naming.JavaBeanReferenceMaker.REF_PROPS_KEY");
            if (refPropsRefAddr != null) {
                refProps = (Set)SerializableUtils.fromByteArray((byte[])((RefAddr)refPropsRefAddr).getContent());
            }
            Map propMap = this.createPropertyMap(beanClass, refAddrsMap);
            return this.findBean(beanClass, propMap, refProps);
        }
        return null;
    }

    private Map createPropertyMap(Class beanClass, Map refAddrsMap) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (PropertyDescriptor pd : pds) {
            Object content;
            String propertyName = pd.getName();
            Class<?> propertyType = pd.getPropertyType();
            Object addr = refAddrsMap.remove(propertyName);
            if (addr == null) continue;
            if (addr instanceof StringRefAddr) {
                content = (String)((StringRefAddr)addr).getContent();
                if (Coerce.canCoerce(propertyType)) {
                    out.put(propertyName, Coerce.toObject((String)content, propertyType));
                    continue;
                }
                PropertyEditor pe = BeansUtils.findPropertyEditor(pd);
                pe.setAsText((String)content);
                out.put(propertyName, pe.getValue());
                continue;
            }
            if (addr instanceof BinaryRefAddr) {
                content = (byte[])((BinaryRefAddr)addr).getContent();
                if (((Object)content).length == 0) {
                    out.put(propertyName, NULL_TOKEN);
                    continue;
                }
                out.put(propertyName, SerializableUtils.fromByteArray((byte[])content));
                continue;
            }
            if (!logger.isLoggable(MLevel.WARNING)) continue;
            logger.warning(this.getClass().getName() + " -- unknown RefAddr subclass: " + addr.getClass().getName());
        }
        for (String type : refAddrsMap.keySet()) {
            if (!logger.isLoggable(MLevel.WARNING)) continue;
            logger.warning(this.getClass().getName() + " -- RefAddr for unknown property: " + type);
        }
        return out;
    }

    protected Object findBean(Class beanClass, Map propertyMap, Set refProps) throws Exception {
        Object bean = beanClass.newInstance();
        BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            String propertyName = pd.getName();
            Object value = propertyMap.get(propertyName);
            Method setter = pd.getWriteMethod();
            if (value != null) {
                if (setter != null) {
                    setter.invoke(bean, value == NULL_TOKEN ? null : value);
                    continue;
                }
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.warning(this.getClass().getName() + ": Could not restore read-only property '" + propertyName + "'.");
                continue;
            }
            if (setter == null || refProps != null && !refProps.contains(propertyName) || !logger.isLoggable(MLevel.WARNING)) continue;
            logger.warning(this.getClass().getName() + " -- Expected writable property ''" + propertyName + "'' left at default value");
        }
        return bean;
    }
}

