/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyObject;

public class JDBC20DataHandler
extends FilterDataHandler {
    public JDBC20DataHandler(DataHandler datahandler) {
        super(datahandler);
    }

    public void setJDBCObject(PreparedStatement stmt, int index, PyObject object, int type) throws SQLException {
        if (DataHandler.checkNull(stmt, index, object, type)) {
            return;
        }
        switch (type) {
            case 2005: {
                if (object instanceof PyFile) {
                    object = ((PyFile)object).read();
                }
                String clob = (String)object.__tojava__(String.class);
                int length = clob.length();
                InputStream stream = new ByteArrayInputStream(clob.getBytes());
                stream = new BufferedInputStream(stream);
                stmt.setBinaryStream(index, stream, length);
                break;
            }
            case 2004: {
                byte[] lob = null;
                Object jobject = null;
                jobject = object instanceof PyFile ? object.__tojava__(InputStream.class) : object.__tojava__(Object.class);
                if (jobject instanceof InputStream) {
                    lob = DataHandler.read(new BufferedInputStream((InputStream)jobject));
                } else if (jobject instanceof byte[]) {
                    lob = (byte[])jobject;
                }
                if (lob != null) {
                    stmt.setBytes(index, lob);
                    break;
                }
            }
            default: {
                super.setJDBCObject(stmt, index, object, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject getPyObject(ResultSet set, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case 2: 
            case 3: {
                try {
                    BigDecimal bd = set.getBigDecimal(col);
                    obj = bd == null ? Py.None : Py.newFloat(bd.doubleValue());
                }
                catch (SQLException e) {
                    obj = super.getPyObject(set, col, type);
                }
                break;
            }
            case 2005: {
                Reader reader = null;
                try {
                    InputStream stream = set.getBinaryStream(col);
                    if (stream == null) {
                        obj = Py.None;
                    } else {
                        reader = new InputStreamReader(stream);
                        reader = new BufferedReader(reader);
                        obj = Py.newString(DataHandler.read(reader));
                    }
                    if (reader == null) break;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception e) {}
                break;
            }
            case 2004: {
                Blob blob = set.getBlob(col);
                if (blob == null) {
                    obj = Py.None;
                    break;
                }
                InputStream stream = null;
                try {
                    stream = blob.getBinaryStream();
                    stream = new BufferedInputStream(stream);
                    obj = Py.java2py(DataHandler.read(stream));
                    if (stream == null) break;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (Exception e) {}
                break;
            }
            case 2003: {
                obj = Py.java2py(set.getArray(col).getArray());
                break;
            }
            default: {
                return super.getPyObject(set, col, type);
            }
        }
        return set.wasNull() || obj == null ? Py.None : obj;
    }
}

