/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.CursorFunc;
import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyConnection;
import com.ziclix.python.sql.PyStatement;
import com.ziclix.python.sql.WarningEvent;
import com.ziclix.python.sql.WarningListener;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyCursor
extends PyObject
implements ClassDictInit,
WarningListener {
    protected Fetch fetch;
    private boolean closed = false;
    protected int arraysize = 1;
    protected int softspace = 0;
    protected PyObject rsType = Py.None;
    protected PyObject rsConcur = Py.None;
    protected PyObject warnings;
    protected PyObject lastrowid;
    protected PyObject updatecount;
    protected boolean dynamicFetch;
    protected PyConnection connection;
    protected DataHandler datahandler;
    protected PyStatement statement;
    private static final DataHandler DATAHANDLER = DataHandler.getSystemDataHandler();
    public static PyClass __class__;
    protected static PyList __methods__;
    protected static PyList __members__;

    PyCursor(PyConnection connection) {
        this(connection, false);
    }

    PyCursor(PyConnection connection, boolean dynamicFetch) {
        this.connection = connection;
        this.datahandler = DATAHANDLER;
        this.dynamicFetch = dynamicFetch;
        this.clear();
    }

    PyCursor(PyConnection connection, boolean dynamicFetch, PyObject rsType, PyObject rsConcur) {
        this(connection, dynamicFetch);
        this.rsType = rsType;
        this.rsConcur = rsConcur;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    public String toString() {
        return "<PyCursor object instance at " + Py.id(this) + ">";
    }

    public void __setattr__(String name, PyObject value) {
        if ("arraysize".equals(name)) {
            this.arraysize = value.__int__().getValue();
        } else if ("softspace".equals(name)) {
            this.softspace = value.__int__().getValue();
        } else if ("datahandler".equals(name)) {
            this.datahandler = (DataHandler)value.__tojava__(DataHandler.class);
        } else {
            super.__setattr__(name, value);
        }
    }

    public PyObject __findattr__(String name) {
        if ("arraysize".equals(name)) {
            return Py.newInteger(this.arraysize);
        }
        if ("softspace".equals(name)) {
            return Py.newInteger(this.softspace);
        }
        if ("__methods__".equals(name)) {
            return __methods__;
        }
        if ("__members__".equals(name)) {
            return __members__;
        }
        if ("description".equals(name)) {
            return this.fetch.description;
        }
        if ("rowcount".equals(name)) {
            return Py.newInteger(this.fetch.rowcount);
        }
        if ("rownumber".equals(name)) {
            int rn = this.fetch.rownumber;
            return rn < 0 ? Py.None : Py.newInteger(rn);
        }
        if ("warnings".equals(name)) {
            return this.warnings;
        }
        if ("lastrowid".equals(name)) {
            return this.lastrowid;
        }
        if ("updatecount".equals(name)) {
            return this.updatecount;
        }
        if ("datahandler".equals(name)) {
            return Py.java2py(this.datahandler);
        }
        if ("dynamic".equals(name)) {
            return this.dynamicFetch ? Py.One : Py.Zero;
        }
        if ("connection".equals(name)) {
            return this.connection;
        }
        if ("closed".equals(name)) {
            return Py.newBoolean(this.closed);
        }
        if ("callproc".equals(name)) {
            try {
                if (!this.getMetaData().supportsStoredProcedures()) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__findattr__(name);
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__version__", Py.newString("$Revision: 1.35 $").__getslice__(Py.newInteger(11), Py.newInteger(-2), null));
        dict.__setitem__("fetchmany", (PyObject)new CursorFunc("fetchmany", 0, 0, 1, "fetch specified number of rows"));
        dict.__setitem__("close", (PyObject)new CursorFunc("close", 1, 0, "close the cursor"));
        dict.__setitem__("fetchall", (PyObject)new CursorFunc("fetchall", 2, 0, "fetch all results"));
        dict.__setitem__("fetchone", (PyObject)new CursorFunc("fetchone", 3, 0, "fetch the next result"));
        dict.__setitem__("nextset", (PyObject)new CursorFunc("nextset", 4, 0, "return next set or None"));
        dict.__setitem__("execute", (PyObject)new CursorFunc("execute", 5, 1, 4, "execute the sql expression"));
        dict.__setitem__("setinputsizes", (PyObject)new CursorFunc("setinputsizes", 6, 1, "not implemented"));
        dict.__setitem__("setoutputsize", (PyObject)new CursorFunc("setoutputsize", 7, 1, 2, "not implemented"));
        dict.__setitem__("callproc", (PyObject)new CursorFunc("callproc", 8, 1, 4, "executes a stored procedure"));
        dict.__setitem__("executemany", (PyObject)new CursorFunc("executemany", 9, 1, 3, "execute sql with the parameter list"));
        dict.__setitem__("scroll", (PyObject)new CursorFunc("scroll", 10, 1, 2, "scroll the cursor in the result set to a new position according to mode"));
        dict.__setitem__("write", (PyObject)new CursorFunc("write", 11, 1, "execute the sql written to this file-like object"));
        dict.__setitem__("prepare", (PyObject)new CursorFunc("prepare", 12, 1, "prepare the sql statement for later execution"));
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("getDataHandler", null);
        dict.__setitem__("warning", null);
        dict.__setitem__("fetch", null);
        dict.__setitem__("statement", null);
        dict.__setitem__("dynamicFetch", null);
        dict.__setitem__("getPyClass", null);
        dict.__setitem__("rsConcur", null);
        dict.__setitem__("rsType", null);
    }

    public void __del__() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.clear();
            this.connection.remove(this);
        }
        finally {
            this.closed = true;
        }
    }

    public PyObject __iter__() {
        return this;
    }

    public PyObject next() {
        PyObject row = this.__iternext__();
        if (row == null) {
            throw Py.StopIteration("");
        }
        return row;
    }

    public PyObject __iternext__() {
        PyObject row = this.fetchone();
        return row.__nonzero__() ? row : null;
    }

    protected DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.connection.getMetaData();
    }

    public DataHandler getDataHandler() {
        return this.datahandler;
    }

    private PyStatement prepareStatement(PyObject sql, PyObject maxRows, boolean prepared) {
        PyStatement stmt = null;
        if (sql == Py.None) {
            return null;
        }
        try {
            if (sql instanceof PyStatement) {
                stmt = (PyStatement)sql;
            } else {
                boolean normal;
                Statement sqlStatement = null;
                String sqlString = sql.__str__().toString();
                if (sqlString.trim().length() == 0) {
                    return null;
                }
                boolean bl = normal = this.rsType == Py.None && this.rsConcur == Py.None;
                if (normal) {
                    sqlStatement = prepared ? this.connection.connection.prepareStatement(sqlString) : this.connection.connection.createStatement();
                } else {
                    int t = this.rsType.__int__().getValue();
                    int c = this.rsConcur.__int__().getValue();
                    sqlStatement = prepared ? this.connection.connection.prepareStatement(sqlString, t, c) : this.connection.connection.createStatement(t, c);
                }
                int style = prepared ? 4 : 2;
                stmt = new PyStatement(sqlStatement, sqlString, style);
            }
            if (maxRows != Py.None) {
                stmt.statement.setMaxRows(maxRows.__int__().getValue());
            }
        }
        catch (AbstractMethodError e) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
        return stmt;
    }

    public void callproc(PyObject name, PyObject params, PyObject bindings, PyObject maxRows) {
        block11: {
            this.clear();
            try {
                if (this.getMetaData().supportsStoredProcedures()) {
                    if (PyCursor.isSeqSeq(params)) {
                        throw zxJDBC.makeException(zxJDBC.NotSupportedError, "sequence of sequences is not supported");
                    }
                    Procedure procedure = this.datahandler.getProcedure(this, name);
                    CallableStatement stmt = procedure.prepareCall(this.rsType, this.rsConcur);
                    if (maxRows != Py.None) {
                        stmt.setMaxRows(maxRows.__int__().getValue());
                    }
                    PyDictionary callableBindings = new PyDictionary();
                    procedure.normalizeInput(params, callableBindings);
                    if (bindings instanceof PyDictionary) {
                        callableBindings.update((PyDictionary)bindings);
                    }
                    this.statement = new PyStatement(stmt, procedure);
                    this.execute(params, callableBindings);
                    break block11;
                }
                throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("noStoredProc"));
            }
            catch (PyException e) {
                throw e;
            }
            catch (Throwable e) {
                throw zxJDBC.makeException(e);
            }
            finally {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
        }
    }

    public void executemany(PyObject sql, PyObject params, PyObject bindings, PyObject maxRows) {
        this.execute(sql, params, bindings, maxRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PyObject sql, PyObject params, PyObject bindings, PyObject maxRows) {
        this.clear();
        boolean hasParams = PyCursor.hasParams(params);
        PyStatement stmt = this.prepareStatement(sql, maxRows, hasParams);
        if (stmt == null) {
            return;
        }
        this.statement = stmt;
        try {
            PyStatement pyStatement = this.statement;
            synchronized (pyStatement) {
                if (hasParams) {
                    if (PyCursor.isSeqSeq(params)) {
                        int len = params.__len__();
                        for (int i = 0; i < len; ++i) {
                            PyObject param = params.__getitem__(i);
                            this.execute(param, bindings);
                        }
                    } else {
                        this.execute(params, bindings);
                    }
                } else {
                    this.execute(Py.None, Py.None);
                }
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
        finally {
            if (this.statement != null && !(sql instanceof PyStatement) && !this.dynamicFetch) {
                this.statement.close();
            }
        }
    }

    protected void execute(PyObject params, PyObject bindings) {
        try {
            Statement stmt = this.statement.statement;
            this.datahandler.preExecute(stmt);
            this.statement.execute(this, params, bindings);
            this.lastrowid = this.datahandler.getRowId(stmt);
            int uc = stmt.getUpdateCount();
            this.updatecount = uc < 0 ? Py.None : Py.newInteger(uc);
            this.warning(new WarningEvent(this, stmt.getWarnings()));
            this.datahandler.postExecute(stmt);
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
    }

    public PyObject fetchone() {
        return this.fetch.fetchone();
    }

    public PyObject fetchall() {
        return this.fetch.fetchall();
    }

    public PyObject fetchmany(int size) {
        return this.fetch.fetchmany(size);
    }

    public PyObject nextset() {
        return this.fetch.nextset();
    }

    public PyStatement prepare(PyObject sql) {
        PyStatement s = this.prepareStatement(sql, Py.None, true);
        this.connection.add(s);
        return s;
    }

    public void scroll(int value, String mode) {
        this.fetch.scroll(value, mode);
    }

    public void warning(WarningEvent event) {
        if (this.warnings == Py.None) {
            this.warnings = new PyList();
        }
        for (SQLWarning warning = event.getWarning(); warning != null; warning = warning.getNextWarning()) {
            PyObject[] warn = new PyObject[]{Py.java2py(warning.getMessage()), Py.java2py(warning.getSQLState()), Py.newInteger(warning.getErrorCode())};
            ((PyList)this.warnings).append(new PyTuple(warn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "cursor is closed");
        }
        this.warnings = Py.None;
        this.lastrowid = Py.None;
        this.updatecount = Py.newInteger(-1);
        try {
            this.fetch.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.fetch = Fetch.newFetch(this.datahandler, this.dynamicFetch);
            this.fetch.addWarningListener(this);
        }
        if (this.statement != null) {
            try {
                if (this.dynamicFetch && !this.connection.contains(this.statement)) {
                    this.statement.close();
                }
            }
            finally {
                this.statement = null;
            }
        }
    }

    public static boolean isSeq(PyObject object) {
        if (object == null || object == Py.None) {
            return false;
        }
        if (object.__tojava__(List.class) != Py.NoConversion) {
            return true;
        }
        return object instanceof PyList || object instanceof PyTuple;
    }

    public static boolean hasParams(PyObject params) {
        if (Py.None == params) {
            return false;
        }
        boolean isSeq = PyCursor.isSeq(params);
        if (!isSeq) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("optionalSecond"));
        }
        return params.__len__() > 0;
    }

    public static boolean isSeqSeq(PyObject object) {
        if (PyCursor.isSeq(object) && object.__len__() > 0) {
            for (int i = 0; i < object.__len__(); ++i) {
                if (PyCursor.isSeq(object.__finditem__(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        PyObject[] m = new PyObject[]{new PyString("close"), new PyString("execute"), new PyString("executemany"), new PyString("fetchone"), new PyString("fetchall"), new PyString("fetchmany"), new PyString("callproc"), new PyString("next"), new PyString("write")};
        __methods__ = new PyList(m);
        m = new PyObject[]{new PyString("arraysize"), new PyString("rowcount"), new PyString("rownumber"), new PyString("description"), new PyString("datahandler"), new PyString("warnings"), new PyString("lastrowid"), new PyString("updatecount"), new PyString("softspace"), new PyString("closed"), new PyString("connection")};
        __members__ = new PyList(m);
    }
}

