/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.Label;
import org.python.core.ClassDictInit;
import org.python.core.Py;

public class ProxyMaker
implements ClassConstants {
    public static final int tBoolean = 0;
    public static final int tByte = 1;
    public static final int tShort = 2;
    public static final int tInteger = 3;
    public static final int tLong = 4;
    public static final int tFloat = 5;
    public static final int tDouble = 6;
    public static final int tCharacter = 7;
    public static final int tVoid = 8;
    public static final int tOther = 9;
    public static final int tNone = 10;
    public static Hashtable types = ProxyMaker.fillTypes();
    Class superclass;
    Class[] interfaces;
    Hashtable names;
    Hashtable supernames = new Hashtable();
    public ClassFile classfile;
    public String myClass;
    public boolean isAdapter = false;

    public static Hashtable fillTypes() {
        Hashtable<Class<Object>, Integer> types2 = new Hashtable<Class<Object>, Integer>();
        types2.put(Boolean.TYPE, new Integer(0));
        types2.put(Byte.TYPE, new Integer(1));
        types2.put(Short.TYPE, new Integer(2));
        types2.put(Integer.TYPE, new Integer(3));
        types2.put(Long.TYPE, new Integer(4));
        types2.put(Float.TYPE, new Integer(5));
        types2.put(Double.TYPE, new Integer(6));
        types2.put(Character.TYPE, new Integer(7));
        types2.put(Void.TYPE, new Integer(8));
        return types2;
    }

    public static int getType(Class c) {
        if (c == null) {
            return 10;
        }
        Object i = types.get(c);
        if (i == null) {
            return 9;
        }
        return (Integer)i;
    }

    public ProxyMaker(String classname, Class superclass) {
        this.myClass = "org.python.proxies." + classname;
        if (superclass.isInterface()) {
            this.superclass = Object.class;
            this.interfaces = new Class[]{superclass};
        } else {
            this.superclass = superclass;
            this.interfaces = new Class[0];
        }
    }

    public ProxyMaker(String myClass, Class superclass, Class[] interfaces) {
        this.myClass = myClass;
        if (superclass == null) {
            superclass = Object.class;
        }
        this.superclass = superclass;
        if (interfaces == null) {
            interfaces = new Class[]{};
        }
        this.interfaces = interfaces;
    }

    public static String mapClass(Class c) {
        String name = c.getName();
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name.length());
        int last_index = 0;
        while (index != -1) {
            buf.append(name.substring(last_index, index));
            buf.append("/");
            last_index = index + 1;
            index = name.indexOf(".", last_index);
        }
        buf.append(name.substring(last_index, name.length()));
        return buf.toString();
    }

    public static String mapType(Class type) {
        if (type.isArray()) {
            return "[" + ProxyMaker.mapType(type.getComponentType());
        }
        switch (ProxyMaker.getType(type)) {
            case 1: {
                return "B";
            }
            case 7: {
                return "C";
            }
            case 6: {
                return "D";
            }
            case 5: {
                return "F";
            }
            case 3: {
                return "I";
            }
            case 4: {
                return "J";
            }
            case 2: {
                return "S";
            }
            case 0: {
                return "Z";
            }
            case 8: {
                return "V";
            }
        }
        return "L" + ProxyMaker.mapClass(type) + ";";
    }

    public static String makeSignature(Class[] sig, Class ret) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (int i = 0; i < sig.length; ++i) {
            buf.append(ProxyMaker.mapType(sig[i]));
        }
        buf.append(")");
        buf.append(ProxyMaker.mapType(ret));
        return buf.toString();
    }

    public void doConstants() throws Exception {
        Code code = this.classfile.addMethod("<clinit>", "()V", 8);
        code.return_();
    }

    public static void doReturn(Code code, Class type) throws Exception {
        switch (ProxyMaker.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.ireturn();
                break;
            }
            case 4: {
                code.lreturn();
                break;
            }
            case 5: {
                code.freturn();
                break;
            }
            case 6: {
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.areturn();
            }
        }
    }

    public static void doNullReturn(Code code, Class type) throws Exception {
        switch (ProxyMaker.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.iconst(0);
                code.ireturn();
                break;
            }
            case 4: {
                code.ldc(code.pool.Long(0L));
                code.lreturn();
                break;
            }
            case 5: {
                code.ldc(code.pool.Float(0.0f));
                code.freturn();
                break;
            }
            case 6: {
                code.ldc(code.pool.Double(0.0));
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.aconst_null();
                code.areturn();
            }
        }
    }

    public void callSuper(Code code, String name, String superclass, Class[] parameters, Class ret, String sig) throws Exception {
        code.aload(0);
        int local_index = 1;
        block6: for (int i = 0; i < parameters.length; ++i) {
            switch (ProxyMaker.getType(parameters[i])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    code.iload(local_index);
                    ++local_index;
                    continue block6;
                }
                case 4: {
                    code.lload(local_index);
                    local_index += 2;
                    continue block6;
                }
                case 5: {
                    code.fload(local_index);
                    ++local_index;
                    continue block6;
                }
                case 6: {
                    code.dload(local_index);
                    local_index += 2;
                    continue block6;
                }
                default: {
                    code.aload(local_index);
                    ++local_index;
                }
            }
        }
        int meth = code.pool.Methodref(superclass, name, sig);
        code.invokespecial(meth);
        ProxyMaker.doReturn(code, ret);
    }

    public void doJavaCall(Code code, String name, String type, String jcallName) throws Exception {
        int jcall = code.pool.Methodref("org/python/core/PyObject", jcallName, "([Ljava/lang/Object;)Lorg/python/core/PyObject;");
        int py2j = code.pool.Methodref("org/python/core/Py", "py2" + name, "(Lorg/python/core/PyObject;)" + type);
        code.invokevirtual(jcall);
        code.invokestatic(py2j);
    }

    public void getArgs(Code code, Class[] parameters) throws Exception {
        if (parameters.length == 0) {
            int EmptyObjects = code.pool.Fieldref("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            code.getstatic(EmptyObjects);
        } else {
            code.iconst(parameters.length);
            code.anewarray(code.pool.Class("java/lang/Object"));
            int array = code.getLocal("[org/python/core/PyObject");
            code.astore(array);
            int local_index = 1;
            for (int i = 0; i < parameters.length; ++i) {
                code.aload(array);
                code.iconst(i);
                switch (ProxyMaker.getType(parameters[i])) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        code.iload(local_index);
                        ++local_index;
                        int newInteger = code.pool.Methodref("org/python/core/Py", "newInteger", "(I)Lorg/python/core/PyInteger;");
                        code.invokestatic(newInteger);
                        break;
                    }
                    case 4: {
                        code.lload(local_index);
                        local_index += 2;
                        int newInteger1 = code.pool.Methodref("org/python/core/Py", "newInteger", "(J)Lorg/python/core/PyObject;");
                        code.invokestatic(newInteger1);
                        break;
                    }
                    case 5: {
                        code.fload(local_index);
                        ++local_index;
                        int newFloat = code.pool.Methodref("org/python/core/Py", "newFloat", "(F)Lorg/python/core/PyFloat;");
                        code.invokestatic(newFloat);
                        break;
                    }
                    case 6: {
                        code.dload(local_index);
                        local_index += 2;
                        int newFloat1 = code.pool.Methodref("org/python/core/Py", "newFloat", "(D)Lorg/python/core/PyFloat;");
                        code.invokestatic(newFloat1);
                        break;
                    }
                    case 7: {
                        code.iload(local_index);
                        ++local_index;
                        int newString = code.pool.Methodref("org/python/core/Py", "newString", "(C)Lorg/python/core/PyString;");
                        code.invokestatic(newString);
                        break;
                    }
                    default: {
                        code.aload(local_index);
                        ++local_index;
                    }
                }
                code.aastore();
            }
            code.aload(array);
        }
    }

    public void callMethod(Code code, String name, Class[] parameters, Class ret, Class[] exceptions2) throws Exception {
        Label start = null;
        Label end = null;
        String jcallName = "_jcall";
        int instLocal = 0;
        if (exceptions2.length > 0) {
            start = code.getLabel();
            end = code.getLabel();
            jcallName = "_jcallexc";
            instLocal = code.getLocal("org/python/core/PyObject");
            code.astore(instLocal);
            start.setPosition();
            code.aload(instLocal);
        }
        this.getArgs(code, parameters);
        switch (ProxyMaker.getType(ret)) {
            case 7: {
                this.doJavaCall(code, "char", "C", jcallName);
                break;
            }
            case 0: {
                this.doJavaCall(code, "boolean", "Z", jcallName);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doJavaCall(code, "int", "I", jcallName);
                break;
            }
            case 4: {
                this.doJavaCall(code, "long", "J", jcallName);
                break;
            }
            case 5: {
                this.doJavaCall(code, "float", "F", jcallName);
                break;
            }
            case 6: {
                this.doJavaCall(code, "double", "D", jcallName);
                break;
            }
            case 8: {
                this.doJavaCall(code, "void", "V", jcallName);
                break;
            }
            default: {
                int jcall = code.pool.Methodref("org/python/core/PyObject", jcallName, "([Ljava/lang/Object;)Lorg/python/core/PyObject;");
                code.invokevirtual(jcall);
                int forname = code.pool.Methodref("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                code.ldc(ret.getName());
                code.invokestatic(forname);
                int tojava = code.pool.Methodref("org/python/core/Py", "tojava", "(Lorg/python/core/PyObject;Ljava/lang/Class;)Ljava/lang/Object;");
                code.invokestatic(tojava);
                code.checkcast(code.pool.Class(ProxyMaker.mapClass(ret)));
            }
        }
        if (exceptions2.length > 0) {
            end.setPosition();
        }
        ProxyMaker.doReturn(code, ret);
        if (exceptions2.length > 0) {
            boolean throwableFound = false;
            Label handlerStart = null;
            for (int i = 0; i < exceptions2.length; ++i) {
                handlerStart = code.getLabel();
                handlerStart.setPosition();
                code.stack = 1;
                int excLocal = code.getLocal("java/lang/Throwable");
                code.astore(excLocal);
                code.aload(excLocal);
                code.athrow();
                code.addExceptionHandler(start, end, handlerStart, code.pool.Class(ProxyMaker.mapClass(exceptions2[i])));
                ProxyMaker.doNullReturn(code, ret);
                code.freeLocal(excLocal);
                if (exceptions2[i] != Throwable.class) continue;
                throwableFound = true;
            }
            if (!throwableFound) {
                handlerStart = code.getLabel();
                handlerStart.setPosition();
                code.stack = 1;
                int excLocal = code.getLocal("java/lang/Throwable");
                code.astore(excLocal);
                code.aload(instLocal);
                code.aload(excLocal);
                int jthrow = code.pool.Methodref("org/python/core/PyObject", "_jthrow", "(Ljava/lang/Throwable;)V");
                code.invokevirtual(jthrow);
                code.addExceptionHandler(start, end, handlerStart, code.pool.Class("java/lang/Throwable"));
                code.freeLocal(excLocal);
                ProxyMaker.doNullReturn(code, ret);
            }
            code.freeLocal(instLocal);
        }
    }

    public void addMethod(Method method, int access) throws Exception {
        boolean isAbstract = false;
        if (Modifier.isAbstract(access)) {
            access &= 0xFFFFFBFF;
            isAbstract = true;
        }
        Class[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String sig = ProxyMaker.makeSignature(parameters, ret);
        String name = method.getName();
        this.names.put(name, name);
        Code code = this.classfile.addMethod(name, sig, access);
        code.aload(0);
        code.ldc(name);
        if (!isAbstract) {
            int tmp = code.getLocal("org/python/core/PyObject");
            int jfindattr = code.pool.Methodref("org/python/core/Py", "jfindattr", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.invokestatic(jfindattr);
            code.astore(tmp);
            code.aload(tmp);
            Label callPython = code.getLabel();
            code.ifnonnull(callPython);
            String superclass = ProxyMaker.mapClass(method.getDeclaringClass());
            this.callSuper(code, name, superclass, parameters, ret, sig);
            callPython.setPosition();
            code.aload(tmp);
            this.callMethod(code, name, parameters, ret, method.getExceptionTypes());
            this.addSuperMethod("super__" + name, name, superclass, parameters, ret, sig, access);
        } else if (!this.isAdapter) {
            int jgetattr = code.pool.Methodref("org/python/core/Py", "jgetattr", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.invokestatic(jgetattr);
            this.callMethod(code, name, parameters, ret, method.getExceptionTypes());
        } else {
            int jfindattr = code.pool.Methodref("org/python/core/Py", "jfindattr", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.invokestatic(jfindattr);
            code.dup();
            Label returnNull = code.getLabel();
            code.ifnull(returnNull);
            this.callMethod(code, name, parameters, ret, method.getExceptionTypes());
            returnNull.setPosition();
            code.pop();
            ProxyMaker.doNullReturn(code, ret);
        }
    }

    private String methodString(Method m) {
        StringBuffer buf = new StringBuffer(m.getName());
        buf.append(":");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            buf.append(params[i].getName());
            buf.append(",");
        }
        return buf.toString();
    }

    protected void addMethods(Class c, Hashtable t) throws Exception {
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String s = this.methodString(method);
            if (t.containsKey(s)) continue;
            t.put(s, s);
            int access = method.getModifiers();
            if (Modifier.isStatic(access) || Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                if (Modifier.isFinal(access = access & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(methods[i], access);
                    continue;
                }
            } else if (Modifier.isFinal(access)) continue;
            this.addMethod(methods[i], access);
        }
        Class sc = c.getSuperclass();
        if (sc != null) {
            this.addMethods(sc, t);
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int j = 0; j < interfaces.length; ++j) {
            this.addMethods(interfaces[j], t);
        }
    }

    public void addConstructor(String name, Class[] parameters, Class ret, String sig, int access) throws Exception {
        Code code = this.classfile.addMethod("<init>", sig, access);
        this.callSuper(code, "<init>", name, parameters, Void.TYPE, sig);
    }

    public void addConstructors(Class c) throws Exception {
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        String name = ProxyMaker.mapClass(c);
        for (int i = 0; i < constructors.length; ++i) {
            int access = constructors[i].getModifiers();
            if (Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                access = access & 0xFFFFFFFB | 1;
            }
            Class[] parameters = constructors[i].getParameterTypes();
            String sig = ProxyMaker.makeSignature(parameters, Void.TYPE);
            this.addConstructor(name, parameters, Void.TYPE, sig, access);
        }
    }

    public void addSuperMethod(Method method, int access) throws Exception {
        String superName;
        Class[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String sig = ProxyMaker.makeSignature(parameters, ret);
        String superclass = ProxyMaker.mapClass(method.getDeclaringClass());
        String methodName = superName = method.getName();
        if (Modifier.isFinal(access)) {
            methodName = "super__" + superName;
            access &= 0xFFFFFFEF;
        }
        this.addSuperMethod(methodName, superName, superclass, parameters, ret, sig, access);
    }

    public void addSuperMethod(String methodName, String superName, String declClass, Class[] parameters, Class ret, String sig, int access) throws Exception {
        if (methodName.startsWith("super__")) {
            try {
                this.superclass.getMethod(methodName, parameters);
                return;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                return;
            }
        }
        this.supernames.put(methodName, methodName);
        Code code = this.classfile.addMethod(methodName, sig, access);
        this.callSuper(code, superName, declClass, parameters, ret, sig);
    }

    public void addProxy() throws Exception {
        this.classfile.addField("__proxy", "Lorg/python/core/PyInstance;", 4);
        Code code = this.classfile.addMethod("_setPyInstance", "(Lorg/python/core/PyInstance;)V", 1);
        int field = code.pool.Fieldref(this.classfile.name, "__proxy", "Lorg/python/core/PyInstance;");
        code.aload(0);
        code.aload(1);
        code.putfield(field);
        code.return_();
        code = this.classfile.addMethod("_getPyInstance", "()Lorg/python/core/PyInstance;", 1);
        code.aload(0);
        code.getfield(field);
        code.areturn();
        this.classfile.addField("__systemState", "Lorg/python/core/PySystemState;", 132);
        code = this.classfile.addMethod("_setPySystemState", "(Lorg/python/core/PySystemState;)V", 1);
        field = code.pool.Fieldref(this.classfile.name, "__systemState", "Lorg/python/core/PySystemState;");
        code.aload(0);
        code.aload(1);
        code.putfield(field);
        code.return_();
        code = this.classfile.addMethod("_getPySystemState", "()Lorg/python/core/PySystemState;", 1);
        code.aload(0);
        code.getfield(field);
        code.areturn();
    }

    public void addClassDictInit() throws Exception {
        int n = this.supernames.size();
        this.classfile.addInterface(ProxyMaker.mapClass(ClassDictInit.class));
        Code code = this.classfile.addMethod("classDictInit", "(Lorg/python/core/PyObject;)V", 9);
        code.aload(0);
        code.ldc("__supernames__");
        String[] names = new String[n];
        Enumeration e = this.supernames.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            names[i++] = (String)e.nextElement();
        }
        CodeCompiler.makeStrings(code, names, n);
        int j2py = code.pool.Methodref("org/python/core/Py", "java2py", "(Ljava/lang/Object;)Lorg/python/core/PyObject;");
        code.invokestatic(j2py);
        int setitem = code.pool.Methodref("org/python/core/PyObject", "__setitem__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        code.invokevirtual(setitem);
        code.return_();
    }

    public void build() throws Exception {
        this.names = new Hashtable();
        int access = this.superclass.getModifiers();
        if ((access & 0x10) != 0) {
            throw new InstantiationException("can't subclass final class");
        }
        access = 33;
        this.classfile = new ClassFile(this.myClass, ProxyMaker.mapClass(this.superclass), access);
        this.addProxy();
        this.addConstructors(this.superclass);
        this.classfile.addInterface("org/python/core/PyProxy");
        Hashtable seenmethods = new Hashtable();
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].isAssignableFrom(this.superclass)) {
                Py.writeWarning("compiler", "discarding redundant interface: " + this.interfaces[i].getName());
                continue;
            }
            this.classfile.addInterface(ProxyMaker.mapClass(this.interfaces[i]));
            this.addMethods(this.interfaces[i], seenmethods);
        }
        this.addMethods(this.superclass, seenmethods);
        this.doConstants();
        this.addClassDictInit();
    }

    public static String makeProxy(Class superclass, OutputStream ostream) throws Exception {
        ProxyMaker pm = new ProxyMaker(superclass.getName(), superclass);
        pm.build();
        pm.classfile.write(ostream);
        return pm.myClass;
    }

    public static File makeFilename(String name, File dir) {
        int index = name.indexOf(".");
        if (index == -1) {
            return new File(dir, name + ".class");
        }
        return ProxyMaker.makeFilename(name.substring(index + 1, name.length()), new File(dir, name.substring(0, index)));
    }

    public static OutputStream getFile(String d, String name) throws IOException {
        File dir = new File(d);
        File file = ProxyMaker.makeFilename(name, dir);
        new File(file.getParent()).mkdirs();
        return new FileOutputStream(file);
    }
}

