/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.ExtraMath;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyGetSetDescr;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyComplex
extends PyObject {
    public double real;
    public double imag;
    static PyComplex J = new PyComplex(0.0, 1.0);
    public static final String exposed_name = "complex";
    private static final PyType COMPLEXTYPE = PyType.fromClass(PyComplex.class);

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        dict.__setitem__("imag", (PyObject)new PyGetSetDescr("imag", PyComplex.class, "getImag", null));
        dict.__setitem__("real", (PyObject)new PyGetSetDescr("real", PyComplex.class, "getReal", null));
        class Exposed___abs__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___abs__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___abs__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___abs__();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex___abs__();
            }
        }
        dict.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyComplex.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___float__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___float__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___float__();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex___float__();
            }
        }
        dict.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyComplex.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___int__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___int__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___int__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___int__();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex___int__();
            }
        }
        dict.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyComplex.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___long__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___long__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___long__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___long__();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex___long__();
            }
        }
        dict.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyComplex.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___neg__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___neg__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___neg__();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex___neg__();
            }
        }
        dict.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyComplex.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___pos__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pos__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___pos__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___pos__();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex___pos__();
            }
        }
        dict.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyComplex.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___add__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___add__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyComplex.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___div__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___div__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___div__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___div__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___div__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyComplex.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___divmod__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___divmod__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___divmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___divmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyComplex.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___floordiv__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___floordiv__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___floordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___floordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyComplex.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___mod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mod__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___mod__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___mod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___mod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyComplex.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mul__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___mul__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyComplex.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___radd__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___radd__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___radd__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyComplex.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rdiv__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rdiv__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rdiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rdiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyComplex.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed__rdivmod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed__rdivmod__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed__rdivmod__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rdivmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rdivmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("_rdivmod__", (PyObject)new PyMethodDescr("_rdivmod__", PyComplex.class, 1, 1, new Exposed__rdivmod__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rfloordiv__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rfloordiv__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rfloordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rfloordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyComplex.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmod__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rmod__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyComplex.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmul__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rmul__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyComplex.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rpow__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rpow__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rpow__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rpow__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rpow__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rpow__", (PyObject)new PyMethodDescr("__rpow__", PyComplex.class, 1, 1, new Exposed___rpow__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rsub__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rsub__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rsub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rsub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyComplex.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rtruediv__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rtruediv__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___rtruediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___rtruediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyComplex.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___sub__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___sub__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___sub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___sub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyComplex.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___truediv__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___truediv__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___truediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___truediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyComplex.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___pow__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pow__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___pow__((PyComplex)self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                PyObject ret = this.self.complex___pow__(arg0, arg1);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0, PyObject arg1) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___pow__(arg0, arg1);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.complex___pow__(arg0, null);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyComplex self = (PyComplex)gself;
                PyObject ret = self.complex___pow__(arg0, null);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyComplex.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed_conjugate
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_conjugate(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed_conjugate((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return this.self.complex_conjugate();
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return self.complex_conjugate();
            }
        }
        dict.__setitem__("conjugate", (PyObject)new PyMethodDescr("conjugate", PyComplex.class, 0, 0, new Exposed_conjugate(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___nonzero__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___nonzero__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(this.self.complex___nonzero__());
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return Py.newBoolean(self.complex___nonzero__());
            }
        }
        dict.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyComplex.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___repr__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___repr__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___repr__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.complex_toString());
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return new PyString(self.complex_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyComplex.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___str__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___str__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.complex_toString());
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return new PyString(self.complex_toString());
            }
        }
        dict.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyComplex.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hash__(PyComplex self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___hash__((PyComplex)self, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(this.self.complex_hashCode());
            }

            public PyObject inst_call(PyObject gself) {
                PyComplex self = (PyComplex)gself;
                return Py.newInteger(self.complex_hashCode());
            }
        }
        dict.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyComplex.class, 0, 0, new Exposed___hash__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyComplex.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                return PyComplex.complex_new(this, init, subtype, args, keywords);
            }
        });
    }

    public static PyObject complex_new(PyObject new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        PyComplex ret;
        PyObject imag;
        PyObject real;
        block16: {
            if (args.length == 0) {
                return new PyComplex(0.0, 0.0);
            }
            if (args.length > 2) {
                throw Py.TypeError("complex() takes at most 2 arguments (" + args.length + " given)");
            }
            ArgParser ap = new ArgParser(exposed_name, args, keywords, "real", "imag");
            real = ap.getPyObject(0, Py.Zero);
            imag = ap.getPyObject(1, null);
            if (imag != null) {
                if (real instanceof PyString) {
                    throw Py.TypeError("complex() can't take second arg if first is a string");
                }
                if (imag instanceof PyString) {
                    throw Py.TypeError("complex() second arg can't be a string");
                }
            }
            ret = null;
            try {
                ret = real.__complex__();
            }
            catch (PyException pye) {
                if (Py.matchException(pye, Py.AttributeError)) break block16;
                throw pye;
            }
        }
        try {
            if (ret == null) {
                ret = new PyComplex(real.__float__().getValue(), 0.0);
            }
            if (imag != null) {
                if (ret == real) {
                    ret = new PyComplex(ret.real, ret.imag);
                }
                if (imag instanceof PyComplex) {
                    PyComplex c = (PyComplex)imag;
                    ret.real -= c.imag;
                    ret.imag += c.real;
                } else {
                    ret.imag += imag.__float__().getValue();
                }
            }
            return ret;
        }
        catch (PyException pye) {
            if (Py.matchException(pye, Py.AttributeError)) {
                PyObject o;
                PyObject pyObject = o = ret == null ? real : imag;
                if (!(o instanceof PyInstance)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
            }
            throw pye;
        }
    }

    public PyComplex(double r, double i) {
        super(COMPLEXTYPE);
        this.real = r;
        this.imag = i;
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'complex' object";
    }

    public final PyFloat getReal() {
        return Py.newFloat(this.real);
    }

    public final PyFloat getImag() {
        return Py.newFloat(this.imag);
    }

    public static String toString(double value) {
        if (value == Math.floor(value) && value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    public String toString() {
        return this.complex_toString();
    }

    final String complex_toString() {
        if (this.real == 0.0) {
            return PyComplex.toString(this.imag) + "j";
        }
        if (this.imag >= 0.0) {
            return "(" + PyComplex.toString(this.real) + "+" + PyComplex.toString(this.imag) + "j)";
        }
        return "(" + PyComplex.toString(this.real) + "-" + PyComplex.toString(-this.imag) + "j)";
    }

    public int hashCode() {
        return this.complex_hashCode();
    }

    final int complex_hashCode() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long v = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)v ^ (int)(v >> 32);
    }

    public boolean __nonzero__() {
        return this.complex___nonzero__();
    }

    final boolean complex___nonzero__() {
        return this.real != 0.0 && this.imag != 0.0;
    }

    public int __cmp__(PyObject other) {
        return this.complex___cmp__(other);
    }

    final int complex___cmp__(PyObject other) {
        if (!this.canCoerce(other)) {
            return -2;
        }
        PyComplex c = this.coerce(other);
        double oreal = c.real;
        double oimag = c.imag;
        if (this.real == oreal && this.imag == oimag) {
            return 0;
        }
        if (this.real != oreal) {
            return this.real < oreal ? -1 : 1;
        }
        return this.imag < oimag ? -1 : 1;
    }

    public PyObject __eq__(PyObject other) {
        return this.complex___eq__(other);
    }

    final PyObject complex___eq__(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        PyComplex c = this.coerce(other);
        return Py.newBoolean(this.real == c.real && this.imag == c.imag);
    }

    public PyObject __ne__(PyObject other) {
        return this.complex___ne__(other);
    }

    final PyObject complex___ne__(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        PyComplex c = this.coerce(other);
        return Py.newBoolean(this.real != c.real || this.imag != c.imag);
    }

    private PyObject unsupported_comparison(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        throw Py.TypeError("cannot compare complex numbers using <, <=, >, >=");
    }

    public PyObject __ge__(PyObject other) {
        return this.complex___ge__(other);
    }

    final PyObject complex___ge__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public PyObject __gt__(PyObject other) {
        return this.complex___gt__(other);
    }

    final PyObject complex___gt__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public PyObject __le__(PyObject other) {
        return this.complex___le__(other);
    }

    final PyObject complex___le__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public PyObject __lt__(PyObject other) {
        return this.complex___lt__(other);
    }

    final PyObject complex___lt__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyComplex) {
            return other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        return Py.None;
    }

    private final boolean canCoerce(PyObject other) {
        return other instanceof PyComplex || other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private final PyComplex coerce(PyObject other) {
        if (other instanceof PyComplex) {
            return (PyComplex)other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        return this.complex___add__(right);
    }

    final PyObject complex___add__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        PyComplex c = this.coerce(right);
        return new PyComplex(this.real + c.real, this.imag + c.imag);
    }

    public PyObject __radd__(PyObject left) {
        return this.complex___radd__(left);
    }

    final PyObject complex___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static final PyObject _sub(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real - o2.real, o1.imag - o2.imag);
    }

    public PyObject __sub__(PyObject right) {
        return this.complex___sub__(right);
    }

    final PyObject complex___sub__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._sub(this, this.coerce(right));
    }

    public PyObject __rsub__(PyObject left) {
        return this.complex___rsub__(left);
    }

    final PyObject complex___rsub__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._sub(this.coerce(left), this);
    }

    private static final PyObject _mul(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real * o2.real - o1.imag * o2.imag, o1.real * o2.imag + o1.imag * o2.real);
    }

    public PyObject __mul__(PyObject right) {
        return this.complex___mul__(right);
    }

    final PyObject complex___mul__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mul(this, this.coerce(right));
    }

    public PyObject __rmul__(PyObject left) {
        return this.complex___rmul__(left);
    }

    final PyObject complex___rmul__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mul(this.coerce(left), this);
    }

    private static final PyObject _div(PyComplex a, PyComplex b) {
        double abs_bimag;
        double abs_breal = b.real < 0.0 ? -b.real : b.real;
        double d = abs_bimag = b.imag < 0.0 ? -b.imag : b.imag;
        if (abs_breal >= abs_bimag) {
            if (abs_breal == 0.0) {
                throw Py.ZeroDivisionError("complex division");
            }
            double ratio = b.imag / b.real;
            double denom = b.real + b.imag * ratio;
            return new PyComplex((a.real + a.imag * ratio) / denom, (a.imag - a.real * ratio) / denom);
        }
        double ratio = b.real / b.imag;
        double denom = b.real * ratio + b.imag;
        return new PyComplex((a.real * ratio + a.imag) / denom, (a.imag * ratio - a.real) / denom);
    }

    public PyObject __div__(PyObject right) {
        return this.complex___div__(right);
    }

    final PyObject complex___div__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this, this.coerce(right));
    }

    public PyObject __rdiv__(PyObject left) {
        return this.complex___rdiv__(left);
    }

    final PyObject complex___rdiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this.coerce(left), this);
    }

    public PyObject __floordiv__(PyObject right) {
        return this.complex___floordiv__(right);
    }

    final PyObject complex___floordiv__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right)).__finditem__(0);
    }

    public PyObject __rfloordiv__(PyObject left) {
        return this.complex___floordiv__(left);
    }

    final PyObject complex___rfloordiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this).__finditem__(0);
    }

    public PyObject __truediv__(PyObject right) {
        return this.complex___truediv__(right);
    }

    final PyObject complex___truediv__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._div(this, this.coerce(right));
    }

    public PyObject __rtruediv__(PyObject left) {
        return this.complex___rtruediv__(left);
    }

    final PyObject complex___rtruediv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._div(this.coerce(left), this);
    }

    public PyObject __mod__(PyObject right) {
        return this.complex___mod__(right);
    }

    final PyObject complex___mod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mod(this, this.coerce(right));
    }

    public PyObject __rmod__(PyObject left) {
        return this.complex___rmod__(left);
    }

    final PyObject complex___rmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mod(this.coerce(left), this);
    }

    private static PyObject _mod(PyComplex value, PyComplex right) {
        PyComplex z = (PyComplex)PyComplex._div(value, right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return value.__sub__(z.__mul__(right));
    }

    public PyObject __divmod__(PyObject right) {
        return this.complex___divmod__(right);
    }

    final PyObject complex___divmod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right));
    }

    public PyObject __rdivmod__(PyObject left) {
        return this.complex___rdivmod__(left);
    }

    final PyObject complex___rdivmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this);
    }

    private static PyObject _divmod(PyComplex value, PyComplex right) {
        PyComplex z = (PyComplex)PyComplex._div(value, right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return new PyTuple(new PyObject[]{z, value.__sub__(z.__mul__(right))});
    }

    private static PyObject ipow(PyComplex value, int iexp) {
        int pow = iexp;
        if (pow < 0) {
            pow = -pow;
        }
        double xr = value.real;
        double xi = value.imag;
        double zr = 1.0;
        double zi = 0.0;
        while (pow > 0) {
            double tmp;
            if ((pow & 1) != 0) {
                tmp = zr * xr - zi * xi;
                zi = zi * xr + zr * xi;
                zr = tmp;
            }
            if ((pow >>= 1) == 0) break;
            tmp = xr * xr - xi * xi;
            xi = xr * xi * 2.0;
            xr = tmp;
        }
        PyComplex ret = new PyComplex(zr, zi);
        if (iexp < 0) {
            return new PyComplex(1.0, 0.0).__div__(ret);
        }
        return ret;
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.complex___pow__(right, modulo);
    }

    final PyObject complex___pow__(PyObject right, PyObject modulo) {
        if (modulo != null) {
            throw Py.ValueError("complex modulo");
        }
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._pow(this, this.coerce(right));
    }

    public PyObject __rpow__(PyObject left) {
        return this.complex___rpow__(left);
    }

    final PyObject complex___rpow__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._pow(this.coerce(left), this);
    }

    public static PyObject _pow(PyComplex value, PyComplex right) {
        double xr = value.real;
        double xi = value.imag;
        double yr = right.real;
        double yi = right.imag;
        if (yr == 0.0 && yi == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (xr == 0.0 && xi == 0.0 && (yi != 0.0 || yr < 0.0)) {
            throw Py.ValueError("0.0 to a negative or complex power");
        }
        int iexp = (int)yr;
        if (yi == 0.0 && yr == (double)iexp && iexp >= -128 && iexp <= 128) {
            return PyComplex.ipow(value, iexp);
        }
        double abs = ExtraMath.hypot(xr, xi);
        double len = Math.pow(abs, yr);
        double at = Math.atan2(xi, xr);
        double phase = at * yr;
        if (yi != 0.0) {
            len /= Math.exp(at * yi);
            phase += yi * Math.log(abs);
        }
        return new PyComplex(len * Math.cos(phase), len * Math.sin(phase));
    }

    public PyObject __neg__() {
        return this.complex___neg__();
    }

    final PyObject complex___neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    public PyObject __pos__() {
        return this.complex___pos__();
    }

    final PyObject complex___pos__() {
        return this;
    }

    public PyObject __abs__() {
        return this.complex___abs__();
    }

    final PyObject complex___abs__() {
        return new PyFloat(ExtraMath.hypot(this.real, this.imag));
    }

    public PyInteger __int__() {
        return this.complex___int__();
    }

    final PyInteger complex___int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    public PyLong __long__() {
        return this.complex___long__();
    }

    final PyLong complex___long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    public PyFloat __float__() {
        return this.complex___float__();
    }

    final PyFloat complex___float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    public PyComplex __complex__() {
        return this;
    }

    public PyComplex conjugate() {
        return this.complex_conjugate();
    }

    final PyComplex complex_conjugate() {
        return new PyComplex(this.real, -this.imag);
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }
}

