/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMapIter;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class PyStringMap
extends PyObject {
    private static final int[] primes = new int[]{7, 13, 31, 61, 127, 251, 509, 1021, 2017, 4093, 5987, 9551, 15683, 19609, 31397, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
    private transient String[] keys = null;
    private transient PyObject[] values = null;
    private int size;
    private transient int filled;
    private transient int prime = 0;
    private transient int popfinger;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String[] keyTable = this.keys;
        PyObject[] valueTable = this.values;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            PyObject value = valueTable[i];
            if (value == null) continue;
            out.writeUTF(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prime = 1;
        this.keys = null;
        this.values = null;
        int n = this.size;
        this.resize(n);
        for (int i = 0; i < n; ++i) {
            String key = in.readUTF().intern();
            this.insertkey(key, (PyObject)in.readObject());
        }
    }

    public PyStringMap(int capacity) {
        this.resize(capacity);
    }

    public PyStringMap() {
        this(4);
    }

    public PyStringMap(PyObject[] elements) {
        this(elements.length);
        for (int i = 0; i < elements.length; i += 2) {
            this.__setitem__(elements[i], elements[i + 1]);
        }
    }

    public synchronized int __len__() {
        return this.size;
    }

    public synchronized boolean __nonzero__() {
        return this.size != 0;
    }

    public synchronized PyObject __finditem__(String key) {
        String[] table = this.keys;
        int maxindex = table.length;
        int index = (System.identityHashCode(key) & Integer.MAX_VALUE) % maxindex;
        int stepsize = maxindex / 5;
        String tkey;
        while ((tkey = table[index]) != key) {
            if (tkey == null) {
                return this.values[index];
            }
            index = (index + stepsize) % maxindex;
        }
        return this.values[index];
    }

    public PyObject __finditem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__finditem__(((PyString)key).internedString());
        }
        return null;
    }

    public PyObject __iter__() {
        return new PyStringMapIter(this.keys, this.values);
    }

    private final void insertkey(String key, PyObject value) {
        String[] table = this.keys;
        int maxindex = table.length;
        int index = (System.identityHashCode(key) & Integer.MAX_VALUE) % maxindex;
        int stepsize = maxindex / 5;
        int free_index = -1;
        while (true) {
            String tkey;
            if ((tkey = table[index]) == null) {
                if (free_index != -1) break;
                ++this.filled;
                free_index = index;
                break;
            }
            if (tkey == key) {
                this.values[index] = value;
                return;
            }
            if (tkey == "<deleted key>" && free_index == -1) {
                free_index = index;
            }
            index = (index + stepsize) % maxindex;
        }
        table[free_index] = key;
        this.values[free_index] = value;
        ++this.size;
    }

    private final synchronized void resize(int capacity) {
        int p;
        for (p = this.prime; p < primes.length && primes[p] < capacity; ++p) {
        }
        if (primes[p] < capacity) {
            throw Py.ValueError("can't make hashtable of size: " + capacity);
        }
        capacity = primes[p];
        this.prime = p;
        String[] oldKeys = this.keys;
        PyObject[] oldValues = this.values;
        this.keys = new String[capacity];
        this.values = new PyObject[capacity];
        this.size = 0;
        this.filled = 0;
        if (oldValues != null) {
            int n = oldValues.length;
            for (int i = 0; i < n; ++i) {
                PyObject value = oldValues[i];
                if (value == null) continue;
                this.insertkey(oldKeys[i], value);
            }
        }
    }

    public synchronized void __setitem__(String key, PyObject value) {
        if (2 * this.filled > this.keys.length) {
            this.resize(this.keys.length + 1);
        }
        this.insertkey(key, value);
    }

    public void __setitem__(PyObject key, PyObject value) {
        if (!(key instanceof PyString)) {
            throw Py.TypeError("keys in namespace must be strings");
        }
        this.__setitem__(((PyString)key).internedString(), value);
    }

    public synchronized void __delitem__(String key) {
        String[] table = this.keys;
        int maxindex = table.length;
        int index = (System.identityHashCode(key) & Integer.MAX_VALUE) % maxindex;
        int stepsize = maxindex / 5;
        while (true) {
            String tkey;
            if ((tkey = table[index]) == null) {
                throw Py.KeyError(key);
            }
            if (tkey == key) {
                table[index] = "<deleted key>";
                this.values[index] = null;
                --this.size;
                break;
            }
            index = (index + stepsize) % maxindex;
        }
    }

    public void __delitem__(PyObject key) {
        if (!(key instanceof PyString)) {
            throw Py.KeyError(key.toString());
        }
        this.__delitem__(((PyString)key).internedString());
    }

    public synchronized void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public synchronized String toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        String[] keyTable = this.keys;
        PyObject[] valueTable = this.values;
        int n = keyTable.length;
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < n; ++i) {
            PyObject value = valueTable[i];
            if (value == null) continue;
            buf.append("'");
            buf.append(keyTable[i]);
            buf.append("': ");
            buf.append(value.__repr__().toString());
            buf.append(", ");
        }
        int len = buf.length();
        if (len > 4) {
            buf.setLength(len - 2);
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    public synchronized int __cmp__(PyObject other) {
        int bn;
        if (!(other instanceof PyStringMap) && !(other instanceof PyDictionary)) {
            return -2;
        }
        int an = this.__len__();
        if (an < (bn = other.__len__())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = null;
        bkeys = other instanceof PyStringMap ? ((PyStringMap)other).keys() : ((PyDictionary)other).keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bvalue;
            PyObject bkey;
            PyObject akey = akeys.get(i);
            int c = akey._cmp(bkey = bkeys.get(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            c = avalue._cmp(bvalue = other.__finditem__(bkey));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean has_key(PyObject key) {
        return this.__finditem__(key) != null;
    }

    public PyObject get(PyObject key, PyObject default_object) {
        PyObject o = this.__finditem__(key);
        if (o == null) {
            return default_object;
        }
        return o;
    }

    public PyObject get(PyObject key) {
        return this.get(key, Py.None);
    }

    public synchronized PyStringMap copy() {
        int n = this.keys.length;
        PyStringMap map = new PyStringMap(n);
        System.arraycopy(this.keys, 0, map.keys, 0, n);
        System.arraycopy(this.values, 0, map.values, 0, n);
        map.filled = this.filled;
        map.size = this.size;
        map.prime = this.prime;
        return map;
    }

    public synchronized void update(PyStringMap map) {
        String[] keyTable = map.keys;
        PyObject[] valueTable = map.values;
        int n = keyTable.length;
        if (2 * this.filled + n > this.keys.length) {
            this.resize(2 * this.filled + n);
        }
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null || key == "<deleted key>") continue;
            this.insertkey(key, valueTable[i]);
        }
    }

    public void update(PyDictionary dict) {
        Hashtable table = dict.table;
        Enumeration ek = table.keys();
        Enumeration ev = table.elements();
        int n = table.size();
        for (int i = 0; i < n; ++i) {
            this.__setitem__((PyObject)ek.nextElement(), (PyObject)ev.nextElement());
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        PyObject o = this.__finditem__(key);
        if (o == null) {
            o = failobj;
            this.__setitem__(key, o);
        }
        return o;
    }

    public synchronized PyObject popitem() {
        String tKey;
        if (this.size == 0) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        int index = this.popfinger;
        String[] table = this.keys;
        int maxindex = table.length;
        if (index >= maxindex || index < 0) {
            index = 1;
        }
        while ((tKey = table[index]) == null || tKey == "<deleted key>") {
            if (++index < maxindex) continue;
            index = 0;
        }
        this.popfinger = index + 1;
        PyString key = Py.newString(table[index]);
        PyObject val = this.values[index];
        table[index] = "<deleted key>";
        this.values[index] = null;
        --this.size;
        return new PyTuple(new PyObject[]{key, val});
    }

    public synchronized PyList items() {
        String[] keyTable = this.keys;
        PyObject[] valueTable = this.values;
        int n = keyTable.length;
        PyList l = new PyList();
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null || key == "<deleted key>" || this.values[i] == null) continue;
            l.append(new PyTuple(new PyObject[]{new PyString(key), valueTable[i]}));
        }
        return l;
    }

    synchronized String[] jkeys() {
        String[] keyTable = this.keys;
        int n = keyTable.length;
        String[] newKeys = new String[this.size];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null || key == "<deleted key>") continue;
            newKeys[j++] = key;
        }
        return newKeys;
    }

    public synchronized PyList keys() {
        String[] keyTable = this.keys;
        int n = keyTable.length;
        PyList l = new PyList();
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null || key == "<deleted key>" || this.values[i] == null) continue;
            l.append(new PyString(key));
        }
        return l;
    }

    public synchronized PyList values() {
        PyObject[] valueTable = this.values;
        int n = valueTable.length;
        PyList l = new PyList();
        for (int i = 0; i < n; ++i) {
            PyObject value = valueTable[i];
            if (value == null) continue;
            l.append(value);
        }
        return l;
    }
}

