/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.apache.oro.text.regex.MatchResult;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.RegexObject;
import org.python.modules.re;

public class MatchObject
extends PyObject {
    public String string;
    public int pos;
    public int endpos;
    public RegexObject re;
    private MatchResult match;

    public MatchObject(RegexObject re2, String string, int pos, int endpos, MatchResult match) {
        this.string = string;
        this.pos = pos;
        this.endpos = endpos;
        this.re = re2;
        this.match = match;
    }

    public int start(int g) {
        return this.match.beginOffset(g);
    }

    public int start() {
        return this.start(0);
    }

    public int start(PyString s) {
        return this.start(this.getindex(s));
    }

    public int end(int g) {
        return this.match.endOffset(g);
    }

    public int end() {
        return this.end(0);
    }

    public int end(PyString s) {
        return this.end(this.getindex(s));
    }

    public PyTuple span(int g) {
        return new PyTuple(new PyObject[]{new PyInteger(this.start(g)), new PyInteger(this.end(g))});
    }

    public PyTuple span() {
        return this.span(0);
    }

    public PyTuple span(PyString s) {
        return this.span(this.getindex(s));
    }

    public PyTuple groups(PyObject defalt) {
        int n = this.match.groups() - 1;
        PyObject[] ret = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            String tmp = this.match.group(i + 1);
            ret[i] = tmp == null ? defalt : new PyString(tmp);
        }
        return new PyTuple(ret);
    }

    public PyTuple groups() {
        return this.groups(Py.None);
    }

    private int getindex(PyString s) {
        PyInteger v = (PyInteger)this.re.groupindex.__finditem__(s);
        if (v == null) {
            throw Py.IndexError("group '" + s + "' is undefined");
        }
        return v.getValue();
    }

    private String group(int i) {
        if (i >= this.match.groups()) {
            throw Py.IndexError("group " + i + " is undefined");
        }
        return this.match.group(i);
    }

    private String group(PyString s) {
        return this.group(this.getindex(s));
    }

    private PyObject group(PyObject o) {
        String s;
        if (o instanceof PyInteger) {
            s = this.group(((PyInteger)o).getValue());
        } else if (o instanceof PyString) {
            s = this.group((PyString)o);
        } else {
            throw org.python.modules.re.ReError("group index must be a string or integer");
        }
        if (s == null) {
            return Py.None;
        }
        return new PyString(s);
    }

    public PyObject group(PyObject[] args) {
        int n = args.length;
        if (n == 0) {
            return new PyString(this.group(0));
        }
        if (n == 1) {
            return this.group(args[0]);
        }
        PyObject[] res = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.group(args[i]);
        }
        return new PyTuple(res);
    }

    public PyObject groupdict() {
        return this.groupdict(Py.None);
    }

    public PyObject groupdict(PyObject defalt) {
        PyDictionary dict = new PyDictionary();
        PyList items = this.re.groupindex.items();
        for (int i = 0; i < items.__len__(); ++i) {
            PyTuple t = (PyTuple)items.__getitem__(i);
            PyString name = (PyString)t.__getitem__(0);
            PyInteger index = (PyInteger)t.__getitem__(1);
            String s = this.group(index.getValue());
            if (s == null) {
                dict.__setitem__(name, defalt);
                continue;
            }
            dict.__setitem__(name, (PyObject)new PyString(s));
        }
        return dict;
    }
}

