: MARK    HERE 0 , ;
: BACK    HERE SWAP H! ;
: IF      ?COMP  ['] ?BRANCH , MARK 2 ; IMMEDIATE
: THEN    ?COMP  2 ?PAIR BACK ; IMMEDIATE
: ELSE    ?COMP  2 ?PAIR ['] BRANCH , MARK >R BACK R> 2 ; IMMEDIATE
: BEGIN   ?COMP  HERE  1 ; IMMEDIATE
: UNTIL   ?COMP  1 ?PAIR  ['] ?BRANCH ,  , ; IMMEDIATE
: WHILE   ?COMP  ['] ?BRANCH , MARK 2 ; IMMEDIATE
: REPEAT  ?COMP  ROT  1  ?PAIR  ROT   ['] BRANCH ,  ,  2 ?PAIR BACK ; IMMEDIATE


: DO   \ 94
\ Интерпретация: семантика неопределена.
\ Компиляция: ( C: -- do-sys )
\ Положить do-sys на стек управления. Добавить семантику времени выполнения, 
\ данную ниже, к текущему определению. Семантика незавершена до разрешения
\ потребителем do-sys, таким как LOOP.
\ Время выполнения: ( n1|u1 n2|u2 -- ) ( R: -- loop-sys )
\ Установить параметры цикла на индекс n2|u2 и предел n1|u1. Неопределенная 
\ ситуация возникает, если n1|u1 и n2|u2 не одного типа. Все, что уже 
\ находилось на стеке возвратов, становится недоступным до тех пор, пока не 
\ будут убраны параметры цикла.
  ?COMP
  ['] (DO) ,
  HERE
  0 3
; IMMEDIATE

: ?DO   \ 94 CORE EXT
\ Интерпретация: семантика неопределена.
\ Компиляция: ( C: -- do-sys )
\ Положить do-sys на стек управления. Добавить семантику времени выполнения, 
\ данную ниже, к текущему определению. Семантика незавершена до разрешения
\ потребителем do-sys, таким как LOOP.
\ Время выполнения: ( n1|u1 n2|u2 -- ) ( R: --  | loop-sys )
\ Если n1|u1 равно n2|u2, продолжить выполнение с места, данного потребителем 
\ do-sys. Иначе установить параметры цикла на индекс n2|u2 и предел n1|u1
\ и продолжить выполнение сразу за ?DO. Неопределенная 
\ ситуация возникает, если n1|u1 и n2|u2 не одного типа. Все, что уже 
\ находилось на стеке возвратов, становится недоступным до тех пор, пока не 
\ будут убраны параметры цикла.
  ?COMP
  ['] (?DO) ,
  MARK 
  -1 3
; IMMEDIATE

: LOOP   \ 94
\ Интерпретация: ( C: do-sys -- )
\ Добавить семантику времени выполнения, данную ниже, к текущему определению.
\ Разрешить все появления LEAVE между позицией, данной do-sys и следующей
\ позицией передачи управления для выполнения слов за LOOP.
\ Время выполнения: ( -- ) ( R: loop-sys1 --  | loop-sys2 )
\ Неопределенная ситуация возникает, если параметры цикла недоступны.
\ Прибавить единицу к индексу цикла. Если индекс цикла стал равным пределу, 
\ убрать параметры цикла и продолжить выполнение сразу за циклом. Иначе 
\ продолжить выполнение с начала цикла.
	?COMP 
	3 ?PAIR
	['] (LOOP) ,
	IF ( ?DO ) HERE 1+ OVER H! 1+ THEN
	,
; IMMEDIATE

: +LOOP    \ 94
\ Интерпретация: ( C: do-sys -- )
\ Добавить семантику времени выполнения, данную ниже, к текущему определению.
\ Разрешить все появления LEAVE между позицией, данной do-sys и следующей
\ позицией передачи управления для выполнения слов за LOOP.
\ Время выполнения: ( n -- ) ( R: loop-sys1 --  | loop-sys2 )
\ Неопределенная ситуация возникает, если параметры цикла недоступны.
\ Прибавить n к индексу цикла. Если индекс цикла не пересек границу между
\ пределом цикла минус единица и пределом цикла, продолжить выполнение с
\ начала цикла. Иначе убрать параметры цикла и продолжить выполнение сразу
\ за циклом.
	?COMP 
	3 ?PAIR
	['] (+LOOP) ,
	IF ( ?DO ) HERE 1+ OVER H! 1+ THEN
	,
; IMMEDIATE

: I   \ 94
\ Интерпретация: семантика неопределена.
\ Выполнение: ( -- n|u ) ( R: loop-sys -- loop-sys )
\ n|u - копия текущего (внутреннего) индекса цикла. Неопределенная ситуация 
\ возникает, если парметры цикла недоступны.
  ?COMP  ['] R@ ,
; IMMEDIATE

: UNLOOP  \ 94
\ Интерпретация: семантика неопределена.
\ Выполнение: ( -- ) ( R: loop-sys -- )
\ Убрать параметры цикла текущего уровня. UNLOOP требуется для каждого
\ уровня вложения циклов перед выходом из определения по EXIT.
\ Неоднозначная ситуация возникает, если параметры цикла недоступны.
	['] 2RDROP ,
; IMMEDIATE
