<?php
  include_once('./classes/ArrayRecordSet.php');

	/**
	 * Manage users in a database cluster
	 *
	 * $Id: adminusers.php,v 1.32.2.2 2007/07/09 14:55:22 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';
		
	/**
	 * Show confirmation of change password and actually change password
	 */
	function doChangePassword($confirm, $msg = '', $isnew = "no") {
		global $data, $misc, $db;
		global $lang, $conf, $_server_info;
		
		if ($confirm) {
			if ($isnew == "new")
			  $misc->printTitle($lang['strcreateuser'],'');
			else {
  			$_REQUEST['user'] = $_REQUEST['username'];
  			$misc->printTrail('user');
			  $misc->printTitle($lang['stralter'],'');
			}
			  
			$misc->printMsg($msg);
			
			if (!isset($_POST['password'])) $_POST['password'] = '';
			if (!isset($_POST['confirm'])) $_POST['confirm'] = '';
			
			include_once "waiting.php";
			
			$str_dbcreate = array("admin", "none");
			$str_broker = array("admin", "monitor", "none");
			
			echo "<form action=\"adminusers.php\" method=\"post\">\n";
			echo $misc->form;
			echo "<table>\n";
			
			if ($isnew == "new") {
			   if (!isset($_REQUEST['username'])) $_REQUEST['username']="";
    		echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strusername']}</th>\n";
    		echo "\t\t<td class=\"data1\"><input size=\"15\" name=\"username\" value=\"".$_REQUEST['username']."\"/></td>\n\t</tr>\n";
			}
			else {
  			echo "<input type=\"hidden\" name=\"username\" value=\"".$_REQUEST['username']."\" />\n";
			}
			
			echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strpassword']}</th>\n";
			echo "\t\t<td><input type=\"password\" name=\"password\" size=\"32\" value=\"", 
				htmlspecialchars($_POST['password']), "\" /></td>\n\t</tr>\n";
			echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strconfirm']}</th>\n";
			echo "\t\t<td><input type=\"password\" name=\"confirm\" size=\"32\" value=\"\" /></td>\n\t</tr>\n";

      if ($_server_info['username'] == 'admin') {
  			echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['sqlauthdbcreate']}</th>\n";
  			if (!isset($_REQUEST['dbcreate'])) $_REQUEST['dbcreate'] = "none";
  			echo "\t\t<td>".selmake($str_dbcreate, $_REQUEST['dbcreate'], "dbcreate")."</td>\n\t</tr>\n";
  			echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['sqlauthbroker']}</th>\n";
  			if (!isset($_REQUEST['broker'])) $_REQUEST['broker'] = "none";
  			echo "\t\t<td>".selmake($str_broker, $_REQUEST['broker'], "broker")."</td>\n\t</tr>\n";
  		}

			echo "<table>\n";
			echo "<input type=\"hidden\" name=\"action\" value=\"changepassword\" />\n";
			echo "<input type=\"hidden\" name=\"isnew\" value=\"$isnew\" />\n";
			echo "<input type=\"submit\" name=\"ok\" value=\"{$lang['strok']}\" onclick=\"show_waiting();\"/>\n";
			echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</p></form>\n";
		}
		else {
			// Check that password matches confirmation password
			if ($_POST['password'] != $_POST['confirm'])
				doChangePassword(true, $lang['strpasswordconfirm'], $_REQUEST['isnew']);
			else {
				$msg = "targetid:".$_REQUEST['username']."\n";
        $_POST['password'] = trim($_POST['password']);
        
        if ($_REQUEST['isnew'] == "new") {
       		if ($_POST['username'] == '') {
      			doChangePassword(true, $lang['struserneedsname'], $_REQUEST['isnew']);
      		}
      		else {
    				$message = $msg."password:".$_POST['password']."\n";
  				  $message .= "casauth:".$_REQUEST['broker']."\n";
  				  $message .= "dbcreate:".$_REQUEST['dbcreate']."\n";
            $tk = $misc->ManagerCommand($_server_info['id'], "adddbmtuser" , $message);
          	if ($tk['status']!="success") {
        			doChangePassword(true, $tk['note'], $_REQUEST['isnew']);
        		}
        		else {
        			doDefault($lang['strusercreated'], true);
        		}
        	}
          
        }
        else {
  				$message = $msg."newpassword:".$_POST['password']."\n";

          $tk = $misc->ManagerCommand($_server_info['id'], "setdbmtpasswd" , $message);
        	if ($tk['status']!="success") {
      			doChangePassword(true, $tk['note']);
      		}
      		else {
      		  if ($_server_info['username'] != 'admin')
      			  doChangePassword(true, $lang['strchanged']);
      			else {
    				  $message = $msg."casauth:".$_REQUEST['broker']."\n";
    				  $message .= "dbcreate:".$_REQUEST['dbcreate']."\n";
              $tk = $misc->ManagerCommand($_server_info['id'], "updatedbmtuser" , $message);
            	if ($tk['status']!="success") {
          			doChangePassword(true, $tk['note']);
          		}
          		else {
          			doDefault($lang['strchanged'], true);
          		}
        		}
      		}
      	}
			}
		}		
	}

	/**
	 * Show confirmation of drop and perform actual drop
	 */
	function doDrop($confirm) {
		global $data, $misc, $db, $_server_info;
		global $lang;

		if ($confirm) {
			$misc->printTrail('user');
			$misc->printTitle($lang['strdrop'],'');
			
			echo "<p>", sprintf($lang['strconfdropuser'], $misc->printVal($_REQUEST['username'])), "</p>\n";	
			
      include_once "waiting.php";
			echo "<form action=\"adminusers.php\" method=\"post\">\n";
			echo $misc->form;
			echo "<input type=\"hidden\" name=\"action\" value=\"drop\" />\n";
			echo "<input type=\"hidden\" name=\"username\" value=\"", htmlspecialchars($_REQUEST['username']), "\" />\n";
			echo "<input type=\"submit\" name=\"drop\" value=\"{$lang['strdrop']}\" onclick=\"show_waiting();\"/>\n";
			echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</form>\n";
		}
		else {
      $tk = $misc->ManagerCommand($_server_info['id'], "deletedbmtuser" , "targetid:".$_REQUEST['username']."\n");
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			doDefault($lang['struserdropped'], true);
  		}
		}		
	}
	

	/**
	 * Show default list of users in the database
	 */
	function doDefault($msg = '', $refresh = false) {
		global $data, $misc, $_server_info, $db;
		global $lang;
		
		$misc->printTrail('server');
		$misc->printTabs('server','users');
		$misc->printMsg($msg);

    if ($refresh === true) {
       $misc->ManagerRefresh($_server_info['id'], "dbmtuserinfo");
       $_server_info = $misc->getServerInfo();
    }
    
		function svPre(&$rowdata, $actions) {
		  global $_server_info, $db;
		  
		  if ($rowdata->f['id'] == "admin")
		    $actions['drop']['disable'] = true;
			return $actions;
		}
		
		$columns = array(
			'name' => array(
				'title' => $lang['strusername'],
				'field' => 'id',
			),
			'authdbcreate' => array(
				'title' => $lang['sqlauthdbcreate'],
				'field' => 'dbcreate'
			),
			'authbroker' => array(
				'title' => $lang['sqlauthbroker'],
				'field' => 'casauth'
			),
			'actions' => array(
				'title' => $lang['stractions'],
			),
		);
		
		$actions = array(
		  'drop' => array(
				'title' => $lang['strdrop'],
				'url'   => "adminusers.php?action=confirm_drop&amp;{$misc->href}&amp;",
				'vars'  => array('username' => 'id'),
			),
		  'chgpass' => array(
				'title' => $lang['stralter'],
				'url'   => "adminusers.php?action=confchangepassword&amp;{$misc->href}&amp;",
				'vars'  => array('username' => 'id'),
			),
		);

    $datrows = new ArrayRecordSet($_server_info['userlist']);

		$misc->printTable($datrows, $columns, $actions, $lang['strnousers'], 'svPre');

    echo "<br><ul>\n";
 		echo "<li><a class=\"navlink\" href=\"adminusers.php?action=create&amp;{$misc->href}\">{$lang['strcreateuser']}</a></li>\n";
 		echo "<li><a class=\"navlink\" href=\"adminusers.php?action=refresh&amp;{$misc->href}\">{$lang['strrefresh']}</a></li>\n";
    echo "</ul>\n";
	}


	$misc->printHeader($lang['strusers']);
	$misc->printBody();

  if ($_server_info['username'] != 'admin') {
  	if ($action == 'changepassword' && isset($_REQUEST['ok'])) {
  	  doChangePassword(false);
  	}
  	else {
    	$_REQUEST['username'] = $_server_info['username'];
  		doChangePassword(true);
  	}
  }
  else {
  	switch ($action) {
  		case 'changepassword':
  			if (isset($_REQUEST['ok'])) doChangePassword(false);
  			else doDefault();
  			break;
  		case 'confchangepassword':
  			doChangePassword(true);
  			break;			
  		case 'create': // edit & create
  			doChangePassword(true, '', "new");
  			break;
  		case 'drop':
  			if (isset($_REQUEST['cancel'])) doDefault();
  			else doDrop(false);
  			break;
  		case 'confirm_drop':
  			doDrop(true);
  			break;
  		case 'refresh':
  			doDefault('', true);
  			break;
  		default:
  			doDefault();
  			break;
  	}	
  }
	$misc->printFooter();
?>
