<?php
  include_once('./classes/ArrayRecordSet.php');

	/**
	 * Manage databases within a server
	 *
	 * $Id: all_broker.php,v 1.45.2.2 2007/07/09 14:55:21 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');
	
	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';

	function startbroker() {
		global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "startunicas" , "");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			sleep(1);
			doDefault('', TRUE);
		}
	}

	function stopbroker() {
		global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "stopunicas" , "");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			sleep(1);
			doDefault('', TRUE);
		}
	}

	function restartbroker() {
		global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "stopunicas" , "");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
		  sleep(2);
      $tk = $misc->ManagerCommand($_server_info['id'], "startunicas" , "");
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			$_reload_browser = true;
  			sleep(1);
  			doDefault('', TRUE);
  		}
		}
	}


	function brokerstart() {
		global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "broker_start" , "bname:".$_REQUEST['broker']);
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			sleep(1);
			doDefault('', TRUE);
		}
	}

	function brokerstop() {
		global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "broker_stop" , "bname:".$_REQUEST['broker']);
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			sleep(1);
			doDefault('', TRUE);
		}
	}

	function brokerrestart() {
		global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "broker_stop" , "bname:".$_REQUEST['broker']);
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
		  sleep(2);
      $tk = $misc->ManagerCommand($_server_info['id'], "broker_start" , "bname:".$_REQUEST['broker']);
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			$_reload_browser = true;
  			sleep(1);
  			doDefault('', TRUE);
  		}
		}
	}




	/**
	 * Show default list of databases in the server
	 */
	function doDefault($msg = '', $refresh = false) {
		global $data, $conf, $misc, $_server_info;
		global $lang;

		function svPre(&$rowdata, $actions) {
		  global $_server_info;
		  if ($_server_info['cassuper'] != "admin") {
			  $actions['brokerstart']['disable'] = true;
			  $actions['brokerstop']['disable'] = true;
			  $actions['brokerrestart']['disable'] = true;
			}
			else {
			  if ($rowdata->f['state'] == "ON") {
			    $actions['brokerstart']['disable'] = true;
			  }
			  else {
  			  $actions['brokerstop']['disable'] = true;
  			  $actions['brokerrestart']['disable'] = true;
			  }
			}
			return $actions;
		}

    if ($refresh === true) {
       $misc->ManagerRefresh($_server_info['id'], "unicasinfo");
       $_server_info = $misc->getServerInfo();
    }
		$misc->printTrail('server');
		$misc->printTabs('server','broker');
		$misc->printTitle($_server_info['UNICASVER'],'');
		$misc->printMsg($msg);


		$columns = array(
			'broker' => array(
				'title' => $lang['strname'],
				'field' => 'name',
			),
			'status' => array(
				'title' => $lang['strstatus'],
				'field' => 'state',
			),
			'process' => array(
				'title' => $lang['strprocess'],
				'field' => 'pid',
			),
			'port' => array(
				'title' => $lang['strport'],
				'field' => 'port',
			),
			'appserver' => array(
				'title' => $lang['strappserver'],
				'field' => 'as',
			),
			'queue' => array(
				'title' => $lang['strqueue'],
				'field' => 'jq',
			),
			'thread' => array(
				'title' => $lang['strthread'],
				'field' => 'thr',
			),
			'request' => array(
				'title' => $lang['strrequest'],
				'field' => 'req',
			),
			'autoadd' => array(
				'title' => $lang['strautoadd'],
				'field' => 'auto',
			),
			'sqllog' => array(
				'title' => $lang['strsqllog'],
				'field' => 'sqll',
			),
			'actions' => array(
				'title' => $lang['stractions'],
			)
		);
		
	  $actions = array(
			'properties' => array(
				'title' => $lang['strproperties'],
				'url'   => "redirect.php?subject=broker&amp;{$misc->href}&amp;",
				'vars'  => array('broker' => 'name'),
			),
			'brokerstart' => array(
				'title' => $lang['strstartdb'],
				'url'   => "all_broker.php?subject=server&amp;action=brokerstart&amp;{$misc->href}&amp;",
				'vars'  => array('broker' => 'name'),
			),
			'brokerrestart' => array(
				'title' => $lang['strrestartdb'],
				'url'   => "all_broker.php?subject=server&amp;action=brokerrestart&amp;{$misc->href}&amp;",
				'vars'  => array('broker' => 'name'),
			),
			'brokerstop' => array(
				'title' => $lang['strstopdb'],
				'url'   => "all_broker.php?subject=server&amp;action=brokerstop&amp;{$misc->href}&amp;",
				'vars'  => array('broker' => 'name'),
			),
		);

    $datrows = new ArrayRecordSet($_server_info['brokers']);
		
		$misc->printTable($datrows, $columns, $actions, $lang['strnodatabases'], 'svPre');

    include_once "waiting.php";
          
		echo "<br><ul>\n";

    if ($_server_info['cassuper'] == 'admin') {
      if ($_server_info['broker'] == 'ON') {
  			echo "\t<li><a href=\"all_broker.php?action=stopbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
  			     " onclick=\"show_waiting();\">{$lang['strstopbrokerenv']}</a></li>\n";
  			echo "\t<li><a href=\"all_broker.php?action=restartbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
  			     " onclick=\"show_waiting();\">{$lang['strrestartbrokerenv']}</a></li>\n";
      }
      else {
  			echo "\t<li><a href=\"all_broker.php?action=startbroker&amp;subject=server&amp;{$misc->href}&amp;\"".
  			     " onclick=\"show_waiting();\">{$lang['strstartbrokerenv']}</a></li>\n";
      }
 			//@@@TODO 1.2 broker add
    }
		echo "\t<li><a href=\"all_broker.php?action=refresh&amp;subject=server&amp;{$misc->href}&amp;\"".
		     " onclick=\"show_waiting();\">{$lang['strrefresh']}</a></li>\n";

		echo "</ul>\n";
	}
	
	$misc->printHeader($lang['strbroker']);
	$misc->printBody();

	switch ($action) {
		case 'startbroker':
			startbroker();
			break;
		case 'stopbroker':
			stopbroker();
			break;
		case 'restartbroker':
			restartbroker();
			break;
		case 'brokerstart':
			brokerstart();
			break;
		case 'brokerstop':
			brokerstop();
			break;
		case 'brokerrestart':
			brokerrestart();
			break;
		default:
			doDefault();
			break;
		case 'refresh':
			doDefault('', TRUE);
			break;
	}	

	$misc->printFooter();

?>
