<?php

	/**
	 * Manage databases within a server
	 *
	 * $Id: all_db.php,v 1.45.2.2 2007/07/09 14:55:21 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');
	
	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';

	function doLogout() {
		global $misc, $lang, $_reload_browser;
		
		$logdb = $_REQUEST['logoutdb'];
		$server_info = $misc->getServerInfo($_REQUEST['server']);
		unset($server_info['login'][$logdb]);
		$misc->setServerInfo(null, $server_info, $_REQUEST['server']);
		doDefault();
		
		$_reload_browser = true;
	}

	function startdb() {
		global $data, $lang, $db, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "startdb" , "dbname:$db");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			$misc->ManagerRefresh($_server_info['id']);
			doDefault();
		}
	}

	function stopdb() {
		global $data, $lang, $db, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "stopdb" , "dbname:$db");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			$misc->ManagerRefresh($_server_info['id']);
			doDefault();
		}
	}

	function restartdb() {
		global $data, $lang, $db, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "stopdb" , "dbname:$db");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
      $tk = $misc->ManagerCommand($_server_info['id'], "startdb" , "dbname:$db");
    	if ($tk['status']!="success") {
  			doDefault($tk['note']);
  		}
  		else {
  			$_reload_browser = true;
  			$misc->ManagerRefresh($_server_info['id']);
  			doDefault();
  		}
		}
	}

	/**
	 * Displays a screen where they can enter a new database
	 */
	function doCreate($msg = '') {
		global $data, $misc;
		global $lang;
		
		$misc->printTrail('server');
		$misc->printTitle($lang['strcreatedatabase']);
		$misc->printMsg($msg);
		
		if (!isset($_POST['formName'])) $_POST['formName'] = '';
		$_POST['formEncoding'] = '';
		if (!isset($_POST['formSpc'])) $_POST['formSpc'] = '';
		if (!isset($_POST['formComment'])) $_POST['formComment'] = '';
		
    include_once "waiting.php";

		echo "<form action=\"all_db.php\" method=\"post\">\n";
		echo "<table>\n";
		echo "\t<tr>\n\t\t<th class=\"data left required\">{$lang['strname']}</th>\n";
		echo "\t\t<td class=\"data1\"><input name=\"formName\" size=\"32\" maxlength=\"{$data->_maxDbLen}\" value=\"",
			htmlspecialchars($_POST['formName']), "\" /></td>\n\t</tr>\n";

		echo "</table>\n";
		echo "<p><input type=\"hidden\" name=\"action\" value=\"save_create\" />\n";
		echo $misc->form;
		echo "<input type=\"submit\" value=\"{$lang['strcreate']}\" onclick=\"show_waiting();\" />\n";
		echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" /></p>\n";
		echo "</form>\n";
	}
	
	/**
	 * Actually creates the new view in the database
	 */
	function doSaveCreate() {
		global $data, $lang, $_reload_browser, $_server_info, $misc;
		
		// Check that they've given a name and a definition
		if ($_POST['formName'] == '') doCreate($lang['strdatabaseneedsname']);
		else {
      $msg = "dbname:".$_POST['formName']."\n";
  		$msg .= "numpage:5000\n";
  		$msg .= "pagesize:4096\n";
  		$msg .= "logsize:10000\n";
  		$msg .= "genvolpath:".$_server_info['UNISQLX_DATABASES']."/".$_POST['formName']."\n";
  		$msg .= "logvolpath:".$_server_info['UNISQLX_DATABASES']."/".$_POST['formName']."\n";
  		$msg .= "open:exvol\n";
  		$msg .= "close:exvol\n";
  		$msg .= "overwrite_config_file:YES";

      $tk = $misc->ManagerCommand($_server_info['id'], "createdb" , $msg);
			if ($tk['status']!="success") {
				doCreate($tk['note']);
			}
			else {
				$_reload_browser = true;
				$misc->ManagerRefresh($_server_info['id']);
				doDefault($lang['strdatabasecreated']);
			}
		}
	}	

	function doAlter() {
		global $data, $lang, $db, $_reload_browser, $_server_info, $misc;

		$requestMsg = "dbname:$db\nrename:".$_POST['newname']."\nforcedel:n\n";

    $tk = $misc->ManagerCommand($_server_info['id'], "renamedb" , $requestMsg);
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			$misc->ManagerRefresh($_server_info['id']);
			doDefault($lang['strdatabasealtered']);
		}
	}

	function doCopy() {
		global $data, $lang, $db, $_reload_browser, $_server_info, $misc;

		$requestMsg = "srcdbname:$db\n";
		$requestMsg .= "destdbname:".$_POST['newname']."\n";
		$requestMsg .= "destdbpath:".$_server_info['UNISQLX_DATABASES']."/".$_POST['newname']."\n";
		$requestMsg .= "exvolpath:".$_server_info['UNISQLX_DATABASES']."/".$_POST['newname']."\n";
		$requestMsg .= "logpath:".$_server_info['UNISQLX_DATABASES']."/".$_POST['newname']."\n";
		$requestMsg .= "overwrite:n\n";
		$requestMsg .= "move:n\n";
		$requestMsg .= "advanced:off\n";

    $tk = $misc->ManagerCommand($_server_info['id'], "copydb" , $requestMsg);
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			$misc->ManagerRefresh($_server_info['id']);
			doDefault($lang['strdatabasecopyed']);
		}
	}
	
	function doDrop() {
		global $data, $lang, $db, $_reload_browser, $_server_info, $misc;
		
    $tk = $misc->ManagerCommand($_server_info['id'], "deletedb" , "dbname:$db\ndelbackup:n\n");
  	if ($tk['status']!="success") {
			doDefault($tk['note']);
		}
		else {
			$_reload_browser = true;
			$misc->ManagerRefresh($_server_info['id']);
			doDefault($lang['strdatabasedropped']);
		}
	}


	/**
	 * Show default list of databases in the server
	 */
	function doDefault($msg = '') {
		global $data, $conf, $misc, $_server_info;
		global $lang;

		$misc->printTrail('server');
		$misc->printTabs('server','databases');
		$misc->printMsg($msg);
		
		$databases = $misc->getDatabases();

		$columns = array(
			'database' => array(
				'title' => $lang['strdatabase'],
				'field' => 'dbname',
			),
			'databasedir' => array(
				'title' => $lang['strdatabasedir'],
				'field' => 'dbdir',
			),
			'status' => array(
				'title' => $lang['strstatus'],
				'field' => 'status',
			),
			'authority' => array(
				'title' => $lang['strauthority'],
				'field' => 'authority',
			),
			'actions' => array(
				'title' => $lang['stractions'],
			)
		);
		
		$actions = array(
			'properties' => array(
				'title' => $lang['strproperties'],
				'url'   => "redirect.php?subject=database&amp;{$misc->href}&amp;",
				'vars'  => array('database' => 'dbname'),
			),
			'logout' => array(
				'title' => $lang['strlogout'],
				'url'   => "all_db.php?action=logout&amp;{$misc->href}&amp;",
				'vars'  => array('logoutdb' => 'dbname'),
			),
		);
		
		$misc->printTable($databases, $columns, $actions, $lang['strnodatabases'], null, TRUE);

    if ($_server_info['dbsuper']=="admin")
		  echo "<p><a class=\"navlink\" href=\"all_db.php?action=create&amp;{$misc->href}\">{$lang['strcreatedatabase']}</a></p>\n";
	}
	
	function doTree() {
		global $misc, $data, $lang;
		
		$databases = $misc->getDatabases();
		
		$reqvars = $misc->getRequestVars('database');
		
		$attrs = array(
			'text'   => field('dbname'),
			'icon'   => 'Database',
			'toolTip'=> '',
			'action' => url('redirect.php',
							$reqvars,
							array('database' => field('dbname'))
						),
			'branch' => url('database.php',
							$reqvars,
							array(
								'action' => 'tree',
								'database' => field('dbname')
							)
						),
		);
		
		$misc->printTreeXML($databases, $attrs, TRUE);
		exit;
	}

	if ($action == 'tree') doTree();
	
	$misc->printHeader($lang['strdatabases']);
	$misc->printBody();

	switch ($action) {
		case 'logout':
			doLogout();
			break;
		case 'save_create':
			if (isset($_POST['cancel'])) doDefault();
			else doSaveCreate();
			break;
		case 'create':
			doCreate();
			break;
		case 'startdb':
			startdb();
			break;
		case 'stopdb':
			stopdb();
			break;
		case 'restartdb':
			restartdb();
			break;
		case 'alter':
			if (isset($_POST['oldname']) && isset($_POST['newname']) &&
			    $_POST['oldname'] != $_POST['newname'] &&
			   !isset($_POST['cancel']) ) doAlter();
			else doDefault();
			break;			
		case 'copy':
			if (isset($_POST['oldname']) && isset($_POST['newname']) &&
			    $_POST['oldname'] != $_POST['newname'] &&
			   !isset($_POST['cancel']) ) doCopy();
			else doDefault();
			break;			
		case 'drop':
			if (isset($_REQUEST['drop'])) doDrop();
			else doDefault();
			break;
		default:
			doDefault();
			break;
	}	

	$misc->printFooter();

?>
