/*
 * Decompiled with CFR 0.152.
 */
package yeoupooh.scrapper;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import yeoupooh.scrapper.DefaultLogger;
import yeoupooh.scrapper.ILogger;
import yeoupooh.scrapper.Scraper;
import yeoupooh.scrapper.SiteFileFilter;

public class ScrapperHelper {
    private String m_scriptDir = null;
    private String m_outputDir = null;
    private String m_mainSite = null;
    private Scraper m_scrapper = null;
    private ILogger m_logger = new DefaultLogger();

    public ScrapperHelper() {
        this.m_scrapper = new Scraper();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("scrapper");
            this.m_scriptDir = resourceBundle.getString("script.dir");
            this.m_outputDir = resourceBundle.getString("output.dir");
            this.m_mainSite = resourceBundle.getString("main.site");
        }
        catch (MissingResourceException missingResourceException) {
            this.m_logger.error("resource bundle not found.");
            this.m_scriptDir = "scripts";
            this.m_outputDir = "output";
            this.m_mainSite = "main.site";
        }
    }

    public void setLogger(ILogger iLogger) {
        this.m_logger = iLogger;
    }

    public Scraper getScraper() {
        return this.m_scrapper;
    }

    public void setScrapperLogger(ILogger iLogger) {
        this.m_scrapper.setLogger(iLogger);
    }

    public void setScriptDir(String string) {
        this.m_scriptDir = string;
    }

    public void setOutputDir(String string) {
        this.m_outputDir = string;
    }

    public void scrapSite(String string) throws IOException {
        this.m_scrapper.startScrapping(this.m_scriptDir, string, this.m_outputDir);
    }

    public void scrapAllSite() throws IOException {
        String[] stringArray = this.getSiteFileList();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.scrapSite(string);
            ++n;
        }
    }

    public void scrapMainSite() throws IOException {
        this.scrapSite(this.m_mainSite);
    }

    public String[] getSiteFileList() {
        File file = new File(this.m_scriptDir);
        return file.list(new SiteFileFilter());
    }

    public String getMainSite() {
        return this.m_mainSite;
    }

    public void setMainSite(String string) {
        this.m_mainSite = string;
    }

    public static void main(String[] stringArray) {
        ScrapperHelper scrapperHelper = new ScrapperHelper();
        scrapperHelper.setScriptDir("scripts");
        scrapperHelper.setOutputDir("output");
        try {
            scrapperHelper.scrapAllSite();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

