/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ControlEditor {
    public int horizontalAlignment = 0x1000000;
    public boolean grabHorizontal = false;
    public int minimumWidth = 0;
    public int verticalAlignment = 0x1000000;
    public boolean grabVertical = false;
    public int minimumHeight = 0;
    Composite parent;
    Control editor;
    private boolean hadFocus;
    private Listener tableListener;
    private Listener scrollbarListener;

    public ControlEditor(Composite parent) {
        ScrollBar vBar;
        this.parent = parent;
        this.tableListener = new Listener(){

            public void handleEvent(Event e) {
                ControlEditor.this.resize();
            }
        };
        parent.addListener(11, this.tableListener);
        this.scrollbarListener = new Listener(){

            public void handleEvent(Event e) {
                ControlEditor.this.scroll(e);
            }
        };
        ScrollBar hBar = parent.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.scrollbarListener);
        }
        if ((vBar = parent.getVerticalBar()) != null) {
            vBar.addListener(13, this.scrollbarListener);
        }
    }

    Rectangle computeBounds() {
        Rectangle clientArea = this.parent.getClientArea();
        Rectangle editorRect = new Rectangle(clientArea.x, clientArea.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            editorRect.width = Math.max(clientArea.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            editorRect.height = Math.max(clientArea.height, this.minimumHeight);
        }
        switch (this.horizontalAlignment) {
            case 131072: {
                editorRect.x += clientArea.width - editorRect.width;
                break;
            }
            case 16384: {
                break;
            }
            default: {
                editorRect.x += (clientArea.width - editorRect.width) / 2;
            }
        }
        switch (this.verticalAlignment) {
            case 1024: {
                editorRect.y += clientArea.height - editorRect.height;
                break;
            }
            case 128: {
                break;
            }
            default: {
                editorRect.y += (clientArea.height - editorRect.height) / 2;
            }
        }
        return editorRect;
    }

    public void dispose() {
        if (!this.parent.isDisposed()) {
            ScrollBar vBar;
            this.parent.removeListener(11, this.tableListener);
            ScrollBar hBar = this.parent.getHorizontalBar();
            if (hBar != null) {
                hBar.removeListener(13, this.scrollbarListener);
            }
            if ((vBar = this.parent.getVerticalBar()) != null) {
                vBar.removeListener(13, this.scrollbarListener);
            }
        }
        this.parent = null;
        this.editor = null;
        this.hadFocus = false;
        this.tableListener = null;
        this.scrollbarListener = null;
    }

    public Control getEditor() {
        return this.editor;
    }

    void resize() {
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        if (this.editor.getVisible()) {
            this.hadFocus = this.editor.isFocusControl();
        }
        this.editor.setBounds(this.computeBounds());
        if (this.hadFocus) {
            this.editor.setFocus();
        }
    }

    void scroll(Event e) {
        boolean visible;
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        if (this.editor.getVisible()) {
            this.hadFocus = this.editor.isFocusControl();
        }
        boolean bl = visible = e.detail != 1;
        if (visible) {
            this.editor.setBounds(this.computeBounds());
        }
        this.editor.setVisible(visible);
        if (visible && this.hadFocus) {
            this.editor.setFocus();
        }
    }

    public void setEditor(Control editor) {
        if (editor == null) {
            this.editor = null;
            return;
        }
        this.editor = editor;
        this.resize();
        editor.setVisible(true);
    }
}

