/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.NoDragUnderEffect;
import org.eclipse.swt.dnd.TableDragUnderEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    private COMObject iDropTarget;
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private int refCount;
    private TransferData selectedDataType;
    private TransferData[] dataTypes;
    private int lastOperation;
    private int keyState;
    private DragUnderEffect effect;
    private int iDataObject;
    static /* synthetic */ Class class$0;

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        this.createCOMInterfaces();
        int result = 0;
        result = COM.CoLockObjectExternal(this.iDropTarget.getAddress(), true, true);
        if (result != 0) {
            DND.error(2001, result);
        }
        if ((result = COM.RegisterDragDrop(control.handle, this.iDropTarget.getAddress())) != 0) {
            DND.error(2001, result);
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.dispose();
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        this.effect = control instanceof Tree ? new TreeDragUnderEffect((Tree)control) : (control instanceof Table ? new TableDragUnderEffect((Table)control) : new NoDragUnderEffect(control));
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 5;
        nArray[4] = 4;
        nArray[6] = 5;
        this.iDropTarget = new COMObject(nArray){

            public int method0(int[] args) {
                return DropTarget.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return DropTarget.this.AddRef();
            }

            public int method2(int[] args) {
                return DropTarget.this.Release();
            }

            public int method3(int[] args) {
                return DropTarget.this.DragEnter(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method4(int[] args) {
                return DropTarget.this.DragOver(args[0], args[1], args[2], args[3]);
            }

            public int method5(int[] args) {
                return DropTarget.this.DragLeave();
            }

            public int method6(int[] args) {
                return DropTarget.this.Drop(args[0], args[1], args[2], args[3], args[4]);
            }
        };
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        COM.RevokeDragDrop(this.control.handle);
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.transferAgents = null;
        this.control = null;
        COM.CoLockObjectExternal(this.iDropTarget.getAddress(), false, true);
        this.Release();
        COM.CoFreeUnusedLibraries();
    }

    private void disposeCOMInterfaces() {
        if (this.iDropTarget != null) {
            this.iDropTarget.dispose();
        }
        this.iDropTarget = null;
    }

    private int DragEnter(int pDataObject, int grfKeyState, int pt_x, int pt_y, int pdwEffect) {
        this.selectedDataType = null;
        this.dataTypes = new TransferData[0];
        this.iDataObject = 0;
        IDataObject dataObject = new IDataObject(pDataObject);
        dataObject.AddRef();
        int[] address = new int[1];
        if (dataObject.EnumFormatEtc(1, address) != 0) {
            OS.MoveMemory(pdwEffect, new int[1], 4);
            dataObject.Release();
            return 0;
        }
        IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(address[0]);
        dataObject.Release();
        this.iDataObject = pDataObject;
        int rgelt = OS.GlobalAlloc(64, 20);
        int[] pceltFetched = new int[1];
        iEnumFORMATETC.Reset();
        block2: while (iEnumFORMATETC.Next(1, rgelt, pceltFetched) == 0 && pceltFetched[0] == 1) {
            TransferData transferData = new TransferData();
            transferData.formatetc = new FORMATETC();
            COM.MoveMemory(transferData.formatetc, rgelt, 20);
            transferData.type = transferData.formatetc.cfFormat;
            int i = 0;
            while (i < this.transferAgents.length) {
                if (this.transferAgents[i].isSupportedType(transferData)) {
                    TransferData[] newDataTypes = new TransferData[this.dataTypes.length + 1];
                    System.arraycopy(this.dataTypes, 0, newDataTypes, 0, this.dataTypes.length);
                    newDataTypes[this.dataTypes.length] = transferData;
                    this.dataTypes = newDataTypes;
                    continue block2;
                }
                ++i;
            }
        }
        OS.GlobalFree(rgelt);
        iEnumFORMATETC.Release();
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.x = pt_x;
        event.y = pt_y;
        event.dataTypes = this.dataTypes;
        event.feedback = 1;
        int[] allowedEffects = new int[1];
        OS.MoveMemory(allowedEffects, pdwEffect, 4);
        allowedEffects[0] = this.osToOp(allowedEffects[0]);
        event.operations = allowedEffects[0];
        if (this.dataTypes.length > 0) {
            event.dataType = this.dataTypes[0];
            event.dataType.pIDataObject = pDataObject;
        }
        this.keyState = this.getOperationFromKeyState(grfKeyState);
        int style = this.getStyle();
        if (this.keyState == 16 && (style & 0x10) == 0) {
            this.keyState = 2;
        }
        event.detail = 0;
        if ((this.keyState & style) == this.keyState) {
            event.detail = this.keyState;
        }
        try {
            this.notifyListeners(2002, event);
        }
        catch (Throwable throwable) {
            OS.MoveMemory(pdwEffect, new int[1], 4);
            return 0;
        }
        if (event.detail == 16) {
            event.detail = 2;
        }
        int i = 0;
        while (i < this.dataTypes.length) {
            if (this.dataTypes[i].equals(event.dataType)) {
                this.selectedDataType = event.dataType;
                break;
            }
            ++i;
        }
        this.lastOperation = 0;
        if (this.selectedDataType != null && (allowedEffects[0] & event.detail) == event.detail) {
            this.lastOperation = event.detail;
        }
        this.effect.show(event.feedback, event.x, event.y);
        OS.MoveMemory(pdwEffect, new int[]{this.opToOs(this.lastOperation)}, 4);
        return 0;
    }

    private int DragLeave() {
        this.effect.show(0, 0, 0);
        this.keyState = 0;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.detail = 0;
        try {
            this.notifyListeners(2003, event);
        }
        catch (Throwable throwable) {}
        return 0;
    }

    private int DragOver(int grfKeyState, int pt_x, int pt_y, int pdwEffect) {
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.x = pt_x;
        event.y = pt_y;
        event.dataTypes = this.dataTypes;
        event.feedback = 1;
        int[] allowedEffects = new int[1];
        OS.MoveMemory(allowedEffects, pdwEffect, 4);
        allowedEffects[0] = this.osToOp(allowedEffects[0]);
        event.operations = allowedEffects[0];
        event.dataType = this.selectedDataType;
        if (event.dataType != null) {
            event.dataType.pIDataObject = this.iDataObject;
        }
        int oldKeyState = this.keyState;
        this.keyState = this.getOperationFromKeyState(grfKeyState);
        int style = this.getStyle();
        if (this.keyState == 16 && (style & 0x10) == 0) {
            this.keyState = 2;
        }
        try {
            if (this.keyState == oldKeyState) {
                event.detail = this.lastOperation;
                this.notifyListeners(2004, event);
            } else {
                event.detail = 0;
                if ((this.keyState & style) == this.keyState) {
                    event.detail = this.keyState;
                }
                this.notifyListeners(2005, event);
            }
        }
        catch (Throwable throwable) {
            OS.MoveMemory(pdwEffect, new int[1], 4);
            return 0;
        }
        if (event.detail == 16) {
            event.detail = 2;
        }
        this.selectedDataType = null;
        int i = 0;
        while (i < this.dataTypes.length) {
            if (this.dataTypes[i].equals(event.dataType)) {
                this.selectedDataType = event.dataType;
                break;
            }
            ++i;
        }
        this.lastOperation = 0;
        if (this.selectedDataType != null && (allowedEffects[0] & event.detail) == event.detail) {
            this.lastOperation = event.detail;
        }
        this.effect.show(event.feedback, event.x, event.y);
        OS.MoveMemory(pdwEffect, new int[]{this.opToOs(this.lastOperation)}, 4);
        return 0;
    }

    private int Drop(int pDataObject, int grfKeyState, int pt_x, int pt_y, int pdwEffect) {
        this.effect.show(0, 0, 0);
        this.keyState = 0;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.detail = 0;
        try {
            this.notifyListeners(2003, event);
        }
        catch (Throwable throwable) {}
        event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.x = pt_x;
        event.y = pt_y;
        event.dataTypes = this.dataTypes;
        int[] allowedEffects = new int[1];
        OS.MoveMemory(allowedEffects, pdwEffect, 4);
        allowedEffects[0] = this.osToOp(allowedEffects[0]);
        event.operations = allowedEffects[0];
        event.dataType = this.selectedDataType;
        if (event.dataType != null) {
            event.dataType.pIDataObject = this.iDataObject;
        }
        event.detail = this.lastOperation;
        try {
            this.notifyListeners(2007, event);
        }
        catch (Throwable throwable) {
            event.dataType = null;
            event.detail = 0;
        }
        this.selectedDataType = null;
        int i = 0;
        while (i < this.dataTypes.length) {
            if (this.dataTypes[i].equals(event.dataType)) {
                this.selectedDataType = event.dataType;
                break;
            }
            ++i;
        }
        this.lastOperation = 0;
        if (this.selectedDataType != null && (allowedEffects[0] & event.detail) == event.detail) {
            this.lastOperation = event.detail;
        }
        if (this.lastOperation != 0) {
            Transfer matchingTransfer = null;
            int i2 = 0;
            while (i2 < this.transferAgents.length) {
                if (this.transferAgents[i2].isSupportedType(event.dataType)) {
                    matchingTransfer = this.transferAgents[i2];
                    break;
                }
                ++i2;
            }
            if (matchingTransfer == null) {
                this.lastOperation = 0;
            } else {
                Object data;
                event.dataType.pIDataObject = pDataObject;
                event.data = data = matchingTransfer.nativeToJava(event.dataType);
                try {
                    this.notifyListeners(2006, event);
                    this.lastOperation = 0;
                    if ((allowedEffects[0] & event.detail) == event.detail) {
                        this.lastOperation = event.detail;
                    }
                }
                catch (Throwable throwable) {
                    this.lastOperation = 0;
                }
            }
        }
        OS.MoveMemory(pdwEffect, new int[]{this.opToOs(this.lastOperation)}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public Display getDisplay() {
        if (this.control == null) {
            DND.error(24);
        }
        return this.control.getDisplay();
    }

    private int getOperationFromKeyState(int grfKeyState) {
        boolean shift;
        boolean ctrl = (grfKeyState & 8) != 0;
        boolean bl = shift = (grfKeyState & 4) != 0;
        if (ctrl && shift) {
            return 4;
        }
        if (ctrl) {
            return 1;
        }
        if (shift) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void notifyListeners(int eventType, Event event) {
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (this.control instanceof Tree) {
            event.item = ((Tree)this.control).getItem(coordinates);
        }
        if (this.control instanceof Table) {
            event.item = ((Table)this.control).getItem(coordinates);
        }
        super.notifyListeners(eventType, event);
    }

    private int opToOs(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 4;
        }
        if ((operation & 2) != 0) {
            osOperation |= 2;
        }
        return osOperation;
    }

    private int osToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 4) != 0) {
            operation |= 4;
        }
        if ((osOperation & 2) != 0) {
            operation |= 2;
        }
        return operation;
    }

    private int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, 16);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIDropTarget)) {
            OS.MoveMemory(ppvObject, new int[]{this.iDropTarget.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new int[1], 4);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }
}

