/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHMENUBARINFO;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPLACEMENT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class Decorations
extends Canvas {
    Image image;
    Menu menuBar;
    Menu[] menus;
    MenuItem[] items;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int swFlags;
    int hAccel;
    int nAccel;
    int hwndCB;
    int hwndTB;
    int hIcon;
    static final int ID_START = 100;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void add(MenuItem item) {
        if (this.items == null) {
            this.items = new MenuItem[12];
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == null) {
                item.id = i + 100;
                this.items[i] = item;
                return;
            }
            ++i;
        }
        item.id = this.items.length + 100;
        MenuItem[] newItems = new MenuItem[this.items.length + 12];
        newItems[this.items.length] = item;
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        this.items = newItems;
    }

    void bringToTop() {
        OS.BringWindowToTop(this.handle);
    }

    static int checkStyle(int style) {
        if (OS.IsWinCE) {
            if ((style & 0x80) != 0) {
                style &= 0xFFFFFF7F;
            }
            if ((style & 0x400) != 0) {
                style &= 0xFFFFFBFF;
            }
            return style;
        }
        if ((style & 0x480) != 0) {
            style |= 0x40;
        }
        if ((style & 0x40) != 0) {
            style |= 0x20;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        int bits = OS.GetWindowLong(this.handle, -16);
        boolean hasMenu = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
        OS.AdjustWindowRectEx(rect, bits, hasMenu, OS.GetWindowLong(this.handle, -20));
        if (this.horizontalBar != null) {
            rect.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rect.right += OS.GetSystemMetrics(2);
        }
        if (hasMenu) {
            RECT testRect = new RECT();
            OS.SetRect(testRect, 0, 0, rect.right - rect.left, rect.bottom - rect.top);
            OS.SendMessage(this.handle, 131, 0, testRect);
            while (testRect.bottom - testRect.top < height) {
                rect.top -= OS.GetSystemMetrics(15) - OS.GetSystemMetrics(6);
                OS.SetRect(testRect, 0, 0, rect.right - rect.left, rect.bottom - rect.top);
                OS.SendMessage(this.handle, 131, 0, testRect);
            }
        }
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    void createAcceleratorTable() {
        this.nAccel = 0;
        this.hAccel = 0;
        int maxAccel = 0;
        if (this.menuBar == null || this.items == null) {
            if (!OS.IsPPC) {
                return;
            }
            maxAccel = 1;
        } else {
            maxAccel = OS.IsPPC ? this.items.length + 1 : this.items.length;
        }
        int size = ACCEL.sizeof;
        ACCEL accel = new ACCEL();
        byte[] buffer1 = new byte[size];
        byte[] buffer2 = new byte[maxAccel * size];
        if (this.menuBar != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                MenuItem item = this.items[i];
                if (item != null && item.accelerator != 0) {
                    Menu parent = item.parent;
                    while (parent != null && parent != this.menuBar) {
                        parent = parent.getParentMenu();
                    }
                    if (parent == this.menuBar) {
                        item.fillAccel(accel);
                        OS.MoveMemory(buffer1, accel, size);
                        System.arraycopy(buffer1, 0, buffer2, this.nAccel * size, size);
                        ++this.nAccel;
                    }
                }
                ++i;
            }
        }
        if (OS.IsPPC) {
            accel.fVirt = (byte)9;
            accel.key = (short)81;
            accel.cmd = 1;
            OS.MoveMemory(buffer1, accel, size);
            System.arraycopy(buffer1, 0, buffer2, this.nAccel * size, size);
            ++this.nAccel;
        }
        if (this.nAccel != 0) {
            this.hAccel = OS.CreateAcceleratorTable(buffer2, this.nAccel);
        }
    }

    void createHandle() {
        super.createHandle();
        if (this.parent == null) {
            return;
        }
        this.setParent();
        this.setSystemMenu();
    }

    void createWidget() {
        super.createWidget();
        this.swFlags = OS.IsWinCE ? OS.SW_SHOWMAXIMIZED : 4;
        this.hAccel = -1;
    }

    void destroyAcceleratorTable() {
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    Menu findMenu(int hMenu) {
        if (this.menus == null) {
            return null;
        }
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null && hMenu == menu.handle) {
                return menu;
            }
            ++i;
        }
        return null;
    }

    MenuItem findMenuItem(int id) {
        if (this.items == null) {
            return null;
        }
        if ((id -= 100) >= 0 && id < this.items.length) {
            return this.items[id];
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT lpwndpl = new WINDOWPLACEMENT();
            lpwndpl.length = 44;
            OS.GetWindowPlacement(this.handle, lpwndpl);
            int width = lpwndpl.right - lpwndpl.left;
            int height = lpwndpl.bottom - lpwndpl.top;
            return new Rectangle(lpwndpl.left, lpwndpl.top, width, height);
        }
        return super.getBounds();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (OS.IsHPC) {
            Rectangle rect = super.getClientArea();
            if (this.hwndCB != 0) {
                int height = OS.CommandBar_Height(this.hwndCB);
                rect.y += height;
                rect.height -= height;
            }
            return rect;
        }
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            RECT rect = new RECT();
            WINDOWPLACEMENT lpwndpl = new WINDOWPLACEMENT();
            lpwndpl.length = 44;
            OS.GetWindowPlacement(this.handle, lpwndpl);
            int width = lpwndpl.right - lpwndpl.left;
            int height = lpwndpl.bottom - lpwndpl.top;
            OS.SetRect(rect, 0, 0, width, height);
            OS.SendMessage(this.handle, 131, 0, rect);
            return new Rectangle(0, 0, rect.right, rect.bottom);
        }
        return super.getClientArea();
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT lpwndpl = new WINDOWPLACEMENT();
            lpwndpl.length = 44;
            OS.GetWindowPlacement(this.handle, lpwndpl);
            return new Point(lpwndpl.left, lpwndpl.top);
        }
        return super.getLocation();
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return this.swFlags == OS.SW_SHOWMAXIMIZED;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsZoomed(this.handle);
        }
        return this.swFlags == OS.SW_SHOWMAXIMIZED;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsIconic(this.handle);
        }
        return this.swFlags == 7;
    }

    String getNameText() {
        return this.getText();
    }

    public Point getSize() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT lpwndpl = new WINDOWPLACEMENT();
            lpwndpl.length = 44;
            OS.GetWindowPlacement(this.handle, lpwndpl);
            int width = lpwndpl.right - lpwndpl.left;
            int height = lpwndpl.bottom - lpwndpl.top;
            return new Point(width, height);
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Point(width, height);
    }

    public String getText() {
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(0, length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        return buffer.toString(0, length);
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    boolean moveMenu(int hMenuSrc, int hMenuDest) {
        boolean success = true;
        TCHAR lpNewItem = new TCHAR(0, "", true);
        int index = 0;
        int cch = 128;
        int byteCount = cch * TCHAR.sizeof;
        int hHeap = OS.GetProcessHeap();
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        MENUITEMINFO lpmii = new MENUITEMINFO();
        lpmii.cbSize = MENUITEMINFO.sizeof;
        lpmii.fMask = 55;
        lpmii.dwTypeData = pszText;
        lpmii.cch = cch;
        while (OS.GetMenuItemInfo(hMenuSrc, 0, true, lpmii)) {
            int uFlags = 1024;
            int uIDNewItem = lpmii.wID;
            if ((lpmii.fType & 0x800) != 0) {
                uFlags |= 0x800;
            } else if (lpmii.hSubMenu != 0) {
                uFlags |= 0x10;
                uIDNewItem = lpmii.hSubMenu;
            }
            success = OS.InsertMenu(hMenuDest, index, uFlags, uIDNewItem, lpNewItem);
            if (!success) break;
            if ((lpmii.fType & 0x800) != 0) {
                lpmii.fMask = 32;
                success = OS.SetMenuItemInfo(hMenuDest, index, true, lpmii);
                if (!success) {
                    break;
                }
            } else {
                lpmii.fMask = 48;
                success = OS.SetMenuItemInfo(hMenuDest, index, true, lpmii);
                if (!success) break;
                if ((lpmii.fState & 3) != 0) {
                    OS.EnableMenuItem(hMenuDest, index, 1025);
                }
                if ((lpmii.fState & 8) != 0) {
                    OS.CheckMenuItem(hMenuDest, index, 1032);
                }
            }
            OS.RemoveMenu(hMenuSrc, 0, 1024);
            ++index;
            lpmii.fMask = 55;
            lpmii.dwTypeData = pszText;
            lpmii.cch = cch;
        }
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        return success;
    }

    void releaseWidget() {
        if (this.menuBar != null) {
            this.menuBar.releaseWidget();
            this.menuBar.releaseHandle();
        }
        this.menuBar = null;
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
        }
        this.menus = null;
        super.releaseWidget();
        if (this.hIcon != 0) {
            OS.DestroyIcon(this.hIcon);
        }
        this.hIcon = 0;
        this.items = null;
        this.image = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
        this.hwndCB = 0;
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    void remove(MenuItem item) {
        if (this.items == null) {
            return;
        }
        this.items[item.id - 100] = null;
        item.id = -1;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        return this.savedFocus != null && this.savedFocus.forceFocus();
    }

    void saveFocus() {
        Control control = this.getDisplay().getFocusControl();
        if (control != null) {
            this.setSavedFocus(control);
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if (OS.IsWinCE) {
            super.setBounds(x, y, width, height, flags);
        }
        if (OS.IsIconic(this.handle) || OS.IsZoomed(this.handle)) {
            WINDOWPLACEMENT lpwndpl = new WINDOWPLACEMENT();
            lpwndpl.length = 44;
            OS.GetWindowPlacement(this.handle, lpwndpl);
            lpwndpl.showCmd = 8;
            if (OS.IsIconic(this.handle)) {
                lpwndpl.showCmd = 7;
            } else if (OS.IsZoomed(this.handle)) {
                lpwndpl.showCmd = OS.SW_SHOWMAXIMIZED;
            }
            if ((flags & 2) == 0) {
                lpwndpl.left = x;
                lpwndpl.top = y;
            }
            if ((flags & 1) == 0) {
                lpwndpl.right = x + width;
                lpwndpl.bottom = y + height;
            }
            OS.SetWindowPlacement(this.handle, lpwndpl);
            return;
        }
        super.setBounds(x, y, width, height, flags);
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                return;
            }
        } else {
            if (button.isDisposed()) {
                this.error(5);
            }
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save || this.saveDefault == null) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (this instanceof Shell) {
            return super.setFocus();
        }
        int hwndFocus = OS.SetFocus(this.getShell().handle);
        return hwndFocus == OS.GetFocus();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (OS.IsWinCE) {
            this.image = image;
            return;
        }
        int hImage = 0;
        if (image != null) {
            if (this.hIcon != 0) {
                OS.DestroyIcon(this.hIcon);
            }
            this.hIcon = 0;
            switch (image.type) {
                case 0: {
                    int hBitmap = image.handle;
                    BITMAP bm = new BITMAP();
                    OS.GetObject(hBitmap, 24, bm);
                    byte[] lpvBits = new byte[(bm.bmWidth + 15) / 16 * 2 * bm.bmHeight];
                    int hMask = OS.CreateBitmap(bm.bmWidth, bm.bmHeight, 1, 1, lpvBits);
                    int hDC = OS.GetDC(this.handle);
                    int hdcMem = OS.CreateCompatibleDC(hDC);
                    int hColor = OS.CreateCompatibleBitmap(hDC, bm.bmWidth, bm.bmHeight);
                    OS.SelectObject(hdcMem, hColor);
                    int hdcBmp = OS.CreateCompatibleDC(hDC);
                    OS.SelectObject(hdcBmp, hBitmap);
                    OS.BitBlt(hdcMem, 0, 0, bm.bmWidth, bm.bmHeight, hdcBmp, 0, 0, 0xCC0020);
                    ICONINFO info = new ICONINFO();
                    info.fIcon = true;
                    info.hbmMask = hMask;
                    info.hbmColor = hColor;
                    hImage = this.hIcon = OS.CreateIconIndirect(info);
                    OS.DeleteObject(hMask);
                    OS.DeleteObject(hColor);
                    OS.DeleteDC(hdcBmp);
                    OS.DeleteDC(hdcMem);
                    OS.ReleaseDC(this.handle, hDC);
                    break;
                }
                case 1: {
                    hImage = image.handle;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.image = image;
        OS.SendMessage(this.handle, 128, 1, hImage);
        if (!OS.IsWinCE && this.hIcon == 0 && (this.style & 0x800) != 0) {
            int flags = 1025;
            OS.RedrawWindow(this.handle, null, 0, flags);
        }
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        int n = this.swFlags = maximized ? OS.SW_SHOWMAXIMIZED : OS.SW_RESTORE;
        if (OS.IsWinCE) {
            if (maximized) {
                if ((this.style & 0x20) == 0) {
                    int bits = OS.GetWindowLong(this.handle, -16);
                    OS.SetWindowLong(this.handle, -16, bits &= 0xFF3FFFFF);
                }
                int flags = 52;
                RECT rect = new RECT();
                OS.SystemParametersInfo(48, 0, rect, 0);
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                if (OS.IsPPC && this.menuBar != null) {
                    RECT rectCB = new RECT();
                    OS.GetWindowRect(this.hwndCB, rectCB);
                    height -= rectCB.bottom - rectCB.top;
                }
                OS.SetWindowPos(this.handle, 0, rect.left, rect.top, width, height, flags);
            } else if ((this.style & 8) == 0) {
                int bits = OS.GetWindowLong(this.handle, -16);
                OS.SetWindowLong(this.handle, -16, bits |= 0xC00000);
                int flags = 39;
                OS.SetWindowPos(this.handle, 0, 0, 0, 0, 0, flags);
            }
        } else {
            if (!OS.IsWindowVisible(this.handle)) {
                return;
            }
            if (maximized == OS.IsZoomed(this.handle)) {
                return;
            }
            OS.ShowWindow(this.handle, this.swFlags);
            OS.UpdateWindow(this.handle);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (OS.IsPPC) {
            boolean resize;
            boolean bl = resize = this.getMaximized() && this.menuBar != menu;
            if (this.menuBar != null) {
                OS.CommandBar_Destroy(this.hwndCB);
                this.hwndCB = 0;
                this.hwndTB = 0;
            }
            this.menuBar = menu;
            if (this.menuBar != null) {
                SHMENUBARINFO mbi = new SHMENUBARINFO();
                mbi.cbSize = 32;
                mbi.hwndParent = this.handle;
                mbi.dwFlags = 0;
                mbi.nToolBarId = 100;
                mbi.hInstRes = OS.GetLibraryHandle();
                boolean success = OS.SHCreateMenuBar(mbi);
                this.hwndCB = mbi.hwndMB;
                if (success && this.hwndCB != 0) {
                    this.hwndTB = OS.GetWindow(this.hwndCB, 5);
                }
                if (this.hwndTB == 0) {
                    if (this.hwndCB != 0) {
                        OS.CommandBar_Destroy(this.hwndCB);
                    }
                    return;
                }
                OS.SendMessage(this.hwndTB, 1046, 0, 0);
                if (this.menuBar.getItemCount() > 0) {
                    MenuItem[] items = this.menuBar.getItems();
                    TBBUTTON lpButton = new TBBUTTON();
                    TBBUTTONINFO info = new TBBUTTONINFO();
                    info.cbSize = 32;
                    info.dwMask = 2;
                    int cch = 128;
                    int hHeap = OS.GetProcessHeap();
                    int byteCount = cch * TCHAR.sizeof;
                    int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                    MENUITEMINFO mii = new MENUITEMINFO();
                    mii.cbSize = MENUITEMINFO.sizeof;
                    mii.fMask = 17;
                    mii.dwTypeData = pszText;
                    int i = 0;
                    while (i < items.length) {
                        MenuItem item = items[i];
                        lpButton.idCommand = item.id;
                        lpButton.fsStyle = (byte)-104;
                        lpButton.fsState = (byte)4;
                        lpButton.iBitmap = -2;
                        if ((item.style & 2) != 0) {
                            lpButton.fsStyle = 1;
                        }
                        OS.SendMessage(this.hwndTB, OS.TB_INSERTBUTTON, i, lpButton);
                        if ((item.style & 2) == 0) {
                            boolean enabled;
                            Menu parent = item.parent;
                            int cfr_ignored_0 = item.id;
                            int hMenu = parent.handle;
                            mii.cch = cch;
                            success = OS.GetMenuItemInfo(hMenu, i, true, mii);
                            if (!success) {
                                this.error(5);
                            }
                            boolean bl2 = enabled = (mii.fState & 3) == 0;
                            if (!enabled) {
                                info.dwMask |= 4;
                                info.fsStyle = 0;
                            }
                            info.pszText = pszText;
                            OS.SendMessage(this.hwndTB, OS.TB_SETBUTTONINFO, item.id, info);
                            Menu menu2 = item.menu;
                            if (menu2 != null) {
                                OS.SendMessage(this.hwndCB, 1424, item.id, menu2.handle);
                            }
                        }
                        ++i;
                    }
                    if (pszText != 0) {
                        OS.HeapFree(hHeap, 0, pszText);
                    }
                }
            }
            if (resize) {
                this.setMaximized(true);
            }
        } else if (OS.IsHPC) {
            boolean resize;
            boolean bl = resize = this.menuBar != menu;
            if (this.menuBar != null) {
                int hMenu = OS.CreateMenu();
                if (!this.moveMenu(this.menuBar.handle, hMenu)) {
                    this.error(29);
                }
                this.menuBar.handle = hMenu;
                if (this.hwndCB != 0) {
                    OS.CommandBar_Destroy(this.hwndCB);
                }
                this.hwndCB = 0;
            }
            this.menuBar = menu;
            if (this.menuBar != null) {
                this.hwndCB = OS.CommandBar_Create(OS.GetModuleHandle(null), this.handle, 1);
                OS.CommandBar_InsertMenubarEx(this.hwndCB, 0, this.menuBar.handle, 0);
                if ((this.style & 0x40) != 0 && (this.style & 0x20) == 0) {
                    OS.CommandBar_AddAdornments(this.hwndCB, 0, 0);
                }
            }
            if (resize) {
                this.sendEvent(11);
                this.layout(false);
            }
        } else {
            this.menuBar = menu;
            int hMenu = 0;
            if (this.menuBar != null) {
                hMenu = this.menuBar.handle;
            }
            OS.SetMenu(this.handle, hMenu);
        }
        this.destroyAcceleratorTable();
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        this.swFlags = OS.SW_RESTORE;
        if (minimized) {
            this.swFlags = 7;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (minimized == OS.IsIconic(this.handle)) {
            return;
        }
        OS.ShowWindow(this.handle, this.swFlags);
        OS.UpdateWindow(this.handle);
    }

    void setParent() {
        Display display = this.getDisplay();
        int hwndParent = this.parent.handle;
        display.lockActiveWindow = true;
        OS.SetParent(this.handle, hwndParent);
        if (!OS.IsWindowVisible(hwndParent)) {
            OS.ShowWindow(this.handle, 8);
        }
        display.lockActiveWindow = false;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            this.savedFocus = null;
            return;
        }
        if (this != control.menuShell()) {
            return;
        }
        this.savedFocus = control;
    }

    void setSystemMenu() {
        if (OS.IsWinCE) {
            return;
        }
        int hMenu = OS.GetSystemMenu(this.handle, false);
        if (hMenu == 0) {
            return;
        }
        int oldCount = OS.GetMenuItemCount(hMenu);
        if ((this.style & 0x10) == 0) {
            OS.DeleteMenu(hMenu, 61440, 0);
        }
        if ((this.style & 0x80) == 0) {
            OS.DeleteMenu(hMenu, 61472, 0);
        }
        if ((this.style & 0x400) == 0) {
            OS.DeleteMenu(hMenu, 61488, 0);
        }
        if ((this.style & 0x480) == 0) {
            OS.DeleteMenu(hMenu, 61728, 0);
        }
        int newCount = OS.GetMenuItemCount(hMenu);
        if ((this.style & 0x40) == 0 || newCount != oldCount) {
            OS.DeleteMenu(hMenu, 61744, 0);
            MENUITEMINFO info = new MENUITEMINFO();
            info.cbSize = MENUITEMINFO.sizeof;
            info.fMask = 2;
            int index = 0;
            while (index < newCount) {
                if (OS.GetMenuItemInfo(hMenu, index, true, info) && info.wID == 61536) break;
                ++index;
            }
            if (index != newCount) {
                OS.DeleteMenu(hMenu, index - 1, 1024);
                if ((this.style & 0x40) == 0) {
                    OS.DeleteMenu(hMenu, 61536, 0);
                }
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        TCHAR buffer = new TCHAR(0, string, true);
        OS.SetWindowText(this.handle, buffer);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            if (OS.IsHPC) {
                OS.CommandBar_DrawMenuBar(this.hwndCB, 0);
            }
            if (OS.IsWinCE) {
                OS.ShowWindow(this.handle, 5);
            } else {
                OS.DrawMenuBar(this.handle);
                OS.ShowWindow(this.handle, this.swFlags);
            }
            OS.UpdateWindow(this.handle);
        } else {
            if (!OS.IsWinCE) {
                this.swFlags = OS.IsIconic(this.handle) ? 7 : (OS.IsZoomed(this.handle) ? OS.SW_SHOWMAXIMIZED : (this.handle == OS.GetActiveWindow() ? OS.SW_RESTORE : 4));
            }
            OS.ShowWindow(this.handle, 0);
            this.sendEvent(23);
        }
    }

    boolean translateAccelerator(MSG msg) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        if (this.hAccel == -1) {
            this.createAcceleratorTable();
        }
        if (this.hAccel == 0) {
            return false;
        }
        return OS.TranslateAccelerator(this.handle, this.hAccel, msg) != 0;
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }

    int widgetExtStyle() {
        int bits = 0;
        if ((this.style & 8) != 0) {
            return bits;
        }
        if (OS.IsPPC && (this.style & 0x40) != 0) {
            bits |= Integer.MIN_VALUE;
        }
        if ((this.style & 4) != 0) {
            bits |= 0x80;
        }
        if ((this.style & 0x10) != 0) {
            return bits;
        }
        if ((this.style & 0x800) != 0) {
            bits |= 1;
        }
        return bits;
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | Integer.MIN_VALUE;
        bits &= 0xEFFEFFFF;
        bits &= 0xFF7FFFFF;
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 0x20) != 0) {
            bits |= 0xC00000;
        }
        if ((this.style & 0x80) != 0) {
            bits |= OS.WS_MINIMIZEBOX;
        }
        if ((this.style & 0x400) != 0) {
            bits |= OS.WS_MAXIMIZEBOX;
        }
        if ((this.style & 0x10) != 0) {
            bits |= 0x40000;
        } else if ((this.style & 0x800) == 0) {
            bits |= 0x800000;
        }
        if (!OS.IsPPC && (this.style & 0x40) != 0) {
            bits |= 0x80000;
        }
        return bits;
    }

    int windowProc(int msg, int wParam, int lParam) {
        switch (msg) {
            case 32768: 
            case 32769: {
                if (this.hAccel == -1) {
                    this.createAcceleratorTable();
                }
                return msg == 32768 ? this.nAccel : this.hAccel;
            }
        }
        return super.windowProc(msg, wParam, lParam);
    }

    LRESULT WM_ACTIVATE(int wParam, int lParam) {
        LRESULT result = super.WM_ACTIVATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((wParam & 0xFFFF) == 0) {
            Shell shell = this.getShell();
            shell.setActiveControl(null);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendEvent(27);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.saveFocus();
        } else {
            this.sendEvent(26);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            if (this.restoreFocus()) {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_CLOSE(int wParam, int lParam) {
        LRESULT result = super.WM_CLOSE(wParam, lParam);
        if (result != null) {
            return result;
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        this.saveFocus();
        return result;
    }

    LRESULT WM_NCACTIVATE(int wParam, int lParam) {
        LRESULT result = super.WM_NCACTIVATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (wParam == 0) {
            Display display = this.getDisplay();
            if (display.lockActiveWindow) {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_QUERYOPEN(int wParam, int lParam) {
        LRESULT result = super.WM_QUERYOPEN(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.sendEvent(20);
        return result;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        this.restoreFocus();
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if (wParam == 1) {
            this.sendEvent(19);
        }
        return result;
    }

    LRESULT WM_WINDOWPOSCHANGING(int wParam, int lParam) {
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        Display display = this.getDisplay();
        if (display.lockActiveWindow) {
            WINDOWPOS lpwp = new WINDOWPOS();
            OS.MoveMemory(lpwp, lParam, 28);
            lpwp.flags |= 4;
            OS.MoveMemory(lParam, lpwp, 28);
        }
        return result;
    }
}

