/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;

    public FontDialog(Shell parent) {
        this(parent, 32768);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData open() {
        int pixels;
        LOGFONT logFont;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        int hHeap = OS.GetProcessHeap();
        CHOOSEFONT lpcf = new CHOOSEFONT();
        lpcf.lStructSize = 60;
        lpcf.hwndOwner = hwndOwner;
        lpcf.Flags = 257;
        int lpLogFont = OS.HeapAlloc(hHeap, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            logFont = this.fontData.data;
            int lfHeight = logFont.lfHeight;
            int hDC = OS.GetDC(0);
            pixels = -Compatibility.round(this.fontData.height * OS.GetDeviceCaps(hDC, 90), 72);
            OS.ReleaseDC(0, hDC);
            logFont.lfHeight = pixels;
            lpcf.Flags |= 0x40;
            OS.MoveMemory(lpLogFont, logFont, LOGFONT.sizeof);
            logFont.lfHeight = lfHeight;
        }
        lpcf.lpLogFont = lpLogFont;
        this.fontData = null;
        if (OS.ChooseFont(lpcf)) {
            logFont = new LOGFONT();
            OS.MoveMemory(logFont, lpLogFont, LOGFONT.sizeof);
            int hDC = OS.GetDC(0);
            int logPixelsY = OS.GetDeviceCaps(hDC, 90);
            pixels = 0;
            if (logFont.lfHeight > 0) {
                int hFont = OS.CreateFontIndirect(logFont);
                int oldFont = OS.SelectObject(hDC, hFont);
                TEXTMETRIC lptm = new TEXTMETRIC();
                OS.GetTextMetrics(hDC, lptm);
                OS.SelectObject(hDC, oldFont);
                OS.DeleteObject(hFont);
                pixels = logFont.lfHeight - lptm.tmInternalLeading;
            } else {
                pixels = -logFont.lfHeight;
            }
            OS.ReleaseDC(0, hDC);
            int points = Compatibility.round(pixels * 72, logPixelsY);
            this.fontData = FontData.win32_new(logFont, points);
        }
        if (lpLogFont != 0) {
            OS.HeapFree(hHeap, 0, lpLogFont);
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }
}

